      SUBROUTINE GLSFIT(FMAT,FWORK,N,NTREND,LDF,YVEC,CMAT,LDC,BETA,
     .                  ERRBTA,DEV,ERRDEV,
     .                  COVBTA,LDCVBT,SGSQR,CHLUP,LDCLUP,CMINV,LDCINV,
     .                  CWORK,LDCWRK,CWRK2,LDCWK2,
     .                  FERR,BERR,WORK,LWORK,
     .                  IPVT,IPIV,IWORK,IERR,METHOD)

      IMPLICIT NONE
      INTEGER N,NTREND,LWORK,IERR,LDF,LDC,IPVT(*),IWORK(*),METHOD,
     .        IPIV(*),LDCVBT,LDCLUP,LDCINV,LDCWRK,LDCWK2,
     .        LDFERR,LDBERR
      DOUBLE PRECISION FMAT(LDF,*),YVEC(*),CMAT(LDC,*),BETA(*),DEV(*),
     .                 WORK(*),COVBTA(LDCVBT,*),CHLUP(LDCLUP,*),
     .                 CMINV(LDCINV,*),CWORK(LDCWRK,*),CWRK2(LDCWK2,*),
     .                 SGSQR,ERRDEV,ERRBTA,FERR(*),BERR(*),FWORK(LDF,*)
c
c     perform a generalized least squares fit, using the weight
c     matrix given by the CMAT (could be a covariance matrix,
c     determined by some variogram model)
c
c     YVEC = FMAT * BETA + DEV
c     E(DEV)   = 0
c     COV(DEV) = SGSQR * CMAT 
c
c     transformation:
c     YVEC_T   = CMAT**-1/2 * YVEC
c     DEV_T    = CMAT**-1/2 * DEV,
c     
c     YVEC_T   = CMAT**-1/2 * F * BETA + DEV_T
c     E(DEV_T)   = 0
c     COV(DEV_T) = I
c
c     DEV_T**T * DEV_T --> min
c
c     YVEC = FMAT * BETA + CMAT**1/2 * DEV_T
c
c     METHOD 1:
c
c     solved by LAPACK routine DGGGLM:
c
c     minimize || DEV_T ||_2  s.t.  YVEC = FMAT * BETA + CMAT**1/2 * DEV_T 
c       BETA
c
c     uses generalized QR decomposition to determine BETA and DEV_T
c     DEV = CMAT**1/2 * DEV_T
c
c     METHOD 2 (numerically not very clever, but sometimes 
c               works better than DGGGLM !?):
c
c     BETA = (FMAT**T * CMAT**-1 * FMAT)**-1 * FMAT**T * CMAT**-1 * YVEC
c     DEV = FMAT * BETA - YVEC
c
c     estimation variance:
c     
c     SQSRQ = DEV**T * DEV / (N-NTREND)
c     COVBTA = SGSQR * (FMAT**T * CMAT**-1 * FMAT)**-1

c     METHOD 0: fallback to LSFIT

c     external subroutines
      EXTERNAL MATPR, DPOTRF, DPOTRI, DGEMM, DGGGLE, DGEFA, DGEDI

c     local variables
      INTEGER I, J, K
      DOUBLE PRECISION DEVSUM, RCOND 

      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D0, ZERO = 0.0D0 )

c     debug options
      CHARACTER*16 NAME
      INTEGER DBGLVL
      COMMON /DEBUG/ DBGLVL

      dbglvl=0


c     check for existence of solution:
      IF (N.LE.NTREND) THEN
         IERR=1
         CALL ERRMSG('GLSFIT: error, N<NTREND',23,IERR)
         RETURN
      END IF

c     choose method:
      IF(METHOD.EQ.0) GO TO 1
      IF(METHOD.EQ.1) GO TO 2
      IF(METHOD.EQ.2) GO TO 3
      IERR=1
      CALL ERRMSG('GLSFIT: error, unknown method',26,IERR)
      RETURN

c     Simple lsfit, only for test purposes
 1    continue
      CALL LSFIT(FMAT,FWORK,N,NTREND,LDF,YVEC,BETA,ERRBTA,
     .           DEV,ERRDEV,
     .           COVBTA,LDCVBT,SGSQR,CMINV,LDCINV,
     .           CWORK,LDCWRK,CWRK2,LDCWK2,
     .           FERR,BERR,WORK,LWORK,
     .           IPVT,IPIV,IWORK,IERR)
      RETURN

c     glsfit with GQR:
 2    CONTINUE
c     determine CMAT**1/2
      DO 20 I=1,N
         DO 10 J=I,N
            CWORK(I,J)=CMAT(I,J)
            CWORK(J,I)=CMAT(I,J)
 10      CONTINUE
 20   CONTINUE


c     eigenvalue decomposition CMAT = V * D * V':
      call DSYEV( 'V', 'U', N, CWORK, LDCWRK, CWRK2(1,1), WORK, LWORK, 
     $            IERR )

c      name='v\0'
c      call matpr(name,cwork,n,n,ldcwrk,dbglvl)
c      name='d\0'
c      call matpr(name,cwrk2,n,1,ldcwk2,dbglvl)
c     calculate sqrt(CMAT) = V * sqrt(D) * V'
      do 60 i=1,n
         do 50 j=1,n
            chlup(i,j)=0
            do 40 k=1,n
               chlup(i,j)=chlup(i,j)+cwork(i,k)*sqrt(cwrk2(k,1))
     .                    *cwork(j,k)
 40         continue
 50      continue
 60   continue
c      name='csqrt\0'
c      call matpr(name,chlup,n,n,ldclup,dbglvl)
c     inverse of CMAT, using DSYSVX
c     rhs (=I)
      DO 80 I=1,N
         DO 70 J=I,N
            IF( I.EQ.J) THEN
               CWORK(I,J)=ONE
            ELSE
               CWORK(I,J)=ZERO
               CWORK(J,I)=ZERO
            END IF
 70      CONTINUE
 80   CONTINUE
      CALL DSYSVX( 'N', 'U', N, N, CMAT, LDC, CWRK2, 
     $             LDCWK2, IPIV, CWORK, LDCWRK, CMINV, LDCINV,
     $             RCOND, FERR, BERR, WORK, LWORK, IWORK, IERR )
      IF ( IERR .NE. 0) THEN         
         IF ( IERR .LT. 0 ) THEN 
            CALL ERRMSG('GLSFIT DSYSVX: argument no IERR wrong',38 , 
     $                  -IERR)
         ELSE
            IF ( IERR .EQ. NTREND+1 ) THEN
               CALL ERRMSG('GLSFIT DSYSVX: matrix singular to working pr
     $ecision',52,0)
            ELSE
               CALL ERRMSG('GLSFIT DSYSVX: D(IERR,IERR)=0 !',32,IERR)
            END IF
         END IF
         RETURN
      END IF
c      name='cinv\0'
c      call matpr(name,cminv,n,n,ldcinv,dbglvl)

c     dont destroy chlup
      DO 100 I=1,N
         DO 90 J=1,N
            CWORK(I,J)=CHLUP(I,J)
 90      CONTINUE
 100  CONTINUE

c     now solve the gls problem
c      name='fmat\0'
c      call matpr(name,fmat,n,ntrend,ldf,dbglvl)
c      name='yvec\0'
c      call matpr(name,yvec,n,1,n,dbglvl)
      CALL DGGGLE(N, NTREND, N, FWORK, LDF, CWORK, LDCWRK, YVEC, BETA, 
     .            DEV, ERRBTA, ERRDEV, WORK, LWORK, IWORK, IERR)
c      name='beta\0'
c      call matpr(name,beta,ntrend,1,ntrend,dbglvl)
c      name='dev\0'
c      call matpr(name,dev,n,1,n,dbglvl)
      IF ( IERR .NE. 0) THEN         
         CALL ERRMSG('GLSFIT DGGGLE: error',21, IERR)
         RETURN
      END IF
c     reverse transform DEV:
      CALL DGEMV('N',N,N,ONE,
     .           CHLUP,LDCLUP,DEV,1,ZERO,WORK,1)

      DO 110 I=1,N
         DEV(I)=WORK(I)
 110  CONTINUE

c     calculate covariance for estimator BETA
c     intermediate step: COVBTA=FMAT^T * CMAT^-1 * FMAT
      CALL DGEMM('T','N',NTREND,N,N,ONE,
     .            FMAT,LDF,CMINV,LDCINV,ZERO,CWORK,LDCWRK)
ccc
c      goto 123

ccccccc FEHLER ccccccccc:
      CALL DGEMM('N','N',NTREND,NTREND,N,ONE,
     .            CWORK,LDCWRK,FMAT,LDF,ZERO,COVBTA,LDCVBT)

ccc
c      goto 123
      DO 130 I=1,NTREND
         DO 120 J=1,NTREND
            IF( I.EQ.J) THEN
               CWORK(I,J)=ONE
            ELSE
               CWORK(I,J)=ZERO
            END IF
 120     CONTINUE
 130  CONTINUE


c     destroys CHLUP with inverse of F'*C**-1*F:
ccc naechster fehler:
c      goto 123
      CALL DSYSVX( 'N', 'U', NTREND, NTREND, COVBTA, LDCVBT, CWRK2, 
     $             LDCWK2, IPIV, CWORK, LDCWRK, CHLUP, LDCLUP,
     $             RCOND, FERR, BERR, WORK, LWORK, IWORK, IERR )
      IF ( IERR .NE. 0) THEN         
         IF ( IERR .LT. 0 ) THEN 
            CALL ERRMSG('GLSFIT DSYSVX: argument no IERR wrong',38, 
     $                  -IERR)
         ELSE
            IF ( IERR .EQ. NTREND+1 ) THEN
               CALL ERRMSG('GLSFIT DSYSVX: matrix singular to working pr
     $ecision',52,0)
            ELSE
               CALL ERRMSG('GLSFIT DSYSVX: D(IERR,IERR)=0 !',32,IERR)
            END IF
         END IF
         RETURN
      END IF

C     EINE WEITERE FEHLERSTELLE !!!      
ccc      goto 123
      DO 150 I=1,NTREND
         DO 140 J=1,NTREND
            COVBTA(I,J)=CHLUP(I,J)
 140     CONTINUE
 150  CONTINUE
      
      GO TO 4

c     direct computation of BETA:
 3    continue
c     inverse of CMAT, using DSYSVX
c     rhs (=I)
      DO 280 I=1,N
         DO 270 J=I,N
            IF( I.EQ.J) THEN
               CWORK(I,J)=ONE
            ELSE
               CWORK(I,J)=ZERO
               CWORK(J,I)=ZERO
            END IF
 270     CONTINUE
 280  CONTINUE
      CALL DSYSVX( 'N', 'U', N, N, CMAT, LDC, CWRK2, 
     $             LDCWK2, IPIV, CWORK, LDCWRK, CMINV, LDCINV,
     $             RCOND, FERR, BERR, WORK, LWORK, IWORK, IERR )
      IF ( IERR .NE. 0) THEN         
         IF ( IERR .LT. 0 ) THEN 
            CALL ERRMSG('GLSFIT DSYSVX: argument no IERR wrong',38 , 
     $                  -IERR)
         ELSE
            IF ( IERR .EQ. NTREND+1 ) THEN
               CALL ERRMSG('GLSFIT DSYSVX: matrix singular to working pr
     $ecision',52,0)
            ELSE
               CALL ERRMSG('GLSFIT DSYSVX: D(IERR,IERR)=0 !',32,IERR)
            END IF
         END IF
         RETURN
      END IF
c     intermediate step: COVBTA=FMAT^T * CMAT^-1 * FMAT
      CALL DGEMM('T','N',NTREND,N,N,ONE,
     .            FMAT,LDF,CMINV,LDCINV,ZERO,CWORK,LDCWRK)

      CALL DGEMM('N','N',NTREND,NTREND,N,ONE,
     .            CWORK,LDCWRK,FMAT,LDF,ZERO,COVBTA,LDCVBT)
      DO 230 I=1,NTREND
         DO 220 J=1,NTREND
            IF( I.EQ.J) THEN
               CWORK(I,J)=ONE
            ELSE
               CWORK(I,J)=ZERO
            END IF
 220     CONTINUE
 230  CONTINUE


c     destroys CHLUP with inverse of F'*C**-1*F:
      CALL DSYSVX( 'N', 'U', NTREND, NTREND, COVBTA, LDCVBT, CWRK2, 
     $             LDCWK2, IPIV, CWORK, LDCWRK, CHLUP, LDCLUP,
     $             RCOND, FERR, BERR, WORK, LWORK, IWORK, IERR )
      IF ( IERR .NE. 0) THEN         
         IF ( IERR .LT. 0 ) THEN 
            CALL ERRMSG('GLSFIT DSYSVX: argument no IERR wrong',38, 
     $                  -IERR)
         ELSE
            IF ( IERR .EQ. NTREND+1 ) THEN
               CALL ERRMSG('GLSFIT DSYSVX: matrix singular to working pr
     $ecision',52,0)
            ELSE
               CALL ERRMSG('GLSFIT DSYSVX: D(IERR,IERR)=0 !',32,IERR)
            END IF
         END IF
         RETURN
      END IF
c     (F'C^-1F)^-1 * F'
      CALL DGEMM('N','T',NTREND,N,NTREND,ONE,
     .           CHLUP,LDCLUP,FMAT,LDF,ZERO,CWORK,LDCWRK)
c     (F'C^-1F)^-1 * F' * C^-1
c     destroys CMAT !
      CALL DGEMM('N','N',NTREND,N,N,ONE,
     .           CWORK,LDCWRK,CMINV,LDCINV,ZERO,CMAT,LDC)
c     calculate estimated parameter
      CALL DGEMV('N',NTREND,N,ONE,
     .           CMAT,LDC,YVEC,1,ZERO,BETA,1)
c     calculate prediction
      CALL DGEMV('N',N,NTREND,ONE,
     .           FMAT,LDF,BETA,1,ZERO,DEV,1)

c     do residuals
      DO 160 I=1,N
         DEV(I)=YVEC(I)-DEV(I)
 160  CONTINUE

c     no error bounds:
      ERRDEV=-1
      ERRBTA=-1


c     finally estimate variance SGSQR
 4    CONTINUE
      IF (N.GT.NTREND) THEN
         DEVSUM=ZERO
         DO 170 I=1,N
            DEVSUM=DEVSUM+DEV(I)*DEV(I)
 170     CONTINUE
         SGSQR=ONE/(N-NTREND)*DEVSUM
      ELSE
         SGSQR=ZERO
      END IF

c     final step
      DO 190 I=1,NTREND
         DO 180 J=1,NTREND
            COVBTA(I,J)=COVBTA(I,J)*SGSQR
 180     CONTINUE
 190  CONTINUE

 123  continue

      RETURN
      END
