      SUBROUTINE DGGGLE(N, M, P, A, LDA, B, LDB, D, Xc, Yc, XERRBD,
     $                  YERRBD, WORK, LWORK, IWORK, INFO)

      IMPLICIT NONE
      INTEGER N, M, P, LDA, LDB, LWORK, IWORK(*), INFO,I1,I2
      DOUBLE PRECISION A(LDA,*), B(LDB,*), D(*), Xc(*), Yc(*),
     $                 XERRBD, YERRBD, WORK(*)

c
c     GLM with error bounds according to code snippet in
c     LAPACK Users Guide, ver 3, transformed from REAL to DOUBLE
c
c     parameters: 
c       see DGGGLM 
c       especially for LWORK (dimension of WORK)
c           LWORK >= max(1,N+M+P) (for DGGGLM)
c       If LWORK=-1 on entry DGGGLE immediately returns with optimum LWORK 
c       in WORK(1)
c
c       +
c       XERRBD, YERRBD  (out) DOUBLEPRECISION:    relative error bounds
c

c     external functions
      DOUBLE PRECISION DLAMCH, DNRM2, DLANTR
      EXTERNAL DLAMCH, DNRM2, DLANTR

c     external subroutines
      EXTERNAL MATPR, DPOTRF, DPOTRI, DGEMM, DGGGLM, DTRCON, DLACON

c     constants
      DOUBLE PRECISION ONE, ZERO
      PARAMETER          ( ONE = 1.0D0, ZERO = 0.0D0 )

c     local variables
      INTEGER I, KASE, NP, LWKOPT
      DOUBLE PRECISION EPSMCH, DNORM, ANORM, BNORM, PBPSNM, TNORM, 
     $                 RCOND, ABPSNM, EST, ABPSBN, CNDAB, CNDBA,
     $                 XNORM, YNORM


      NP = MIN( N, P )
      EPSMCH = DLAMCH( 'E' )
*     Working array size:
      IF(LWORK.EQ.-1) THEN
*        Working array query in DGGGLM         
         CALL DGGGLM( N, M, P, A, LDA, B, LDB, D, Xc, Yc, WORK,
     $               LWORK, INFO )         
         LWKOPT=WORK(1)
*        add some tests for sufficient workspace according to the WORK sizes 
*        in columns 72+ below, don't know if this is really necessary:
         IF(LWKOPT.LE.M+NP+M+3*N) LWKOPT=M+NP+M+3*N
         IF(LWKOPT.LE.M+NP+M+P-N+M) LWKOPT=M+NP+M+P-N+M
         WORK(1)=LWKOPT
         INFO=0
         RETURN
      END IF


*     Compute the 2-norm of the left hand side D
      DNORM = DNRM2( N, D, 1 )
*     Solve the generalized linear model problem
      CALL DGGGLM( N, M, P, A, LDA, B, LDB, D, Xc, Yc, WORK,
     $            LWORK, INFO )
      IF ( INFO .NE. 0) THEN         
         CALL ERRMSG('DGGGLE DGGGLM: U(IERR,IERR) is zero, DGEDI will fai
     $l', INFO)
         RETURN
      END IF
*     Compute the F-norm of A and B                                        LWORK:
      ANORM = DLANTR( 'F', 'U', 'N', M, M, A, LDA, WORK( M+NP+1 ) )        M+NP+M     
      BNORM = DLANTR( 'F', 'U', 'N', N, P, B( 1, MAX( 1, P-N+1 ) ),
     $                LDB, WORK( M+NP+1 ) )                                M+NP+N
*     Compute the 2-norm of Xc
      XNORM = DNRM2( M, Xc, 1 )
*     Condition estimation
      IF( N.EQ.M ) THEN
         PBPSNM = ZERO
         TNORM = DLANTR( '1', 'U', 'N', N, N, A, LDA, WORK( M+NP+M+1 ) )   M+NP+M+N
         CALL DTRCON( '1', 'U', 'N', N, A, LDA, RCOND, WORK( M+NP+M+1 ),   M+NP+M+3*N
     $                IWORK, INFO )
      IF ( INFO .NE. 0) THEN         
         CALL ERRMSG('DGGGLE DTRCON: argument number IERR wrong',-INFO)
         RETURN
      END IF
         ABPSNM = ONE / (RCOND * TNORM )
      ELSE
*        Compute norm of (PB)^+
         TNORM = DLANTR( '1', 'U', 'N', N-M, N-M, B( M+1, P-N+M+1 ),       
     $                   LDB, WORK( M+NP+1 ) )                             M+NP+N-M
         CALL DTRCON( '1', 'U', 'N', N-M, B( M+1, P-N+M+1 ), LDB, RCOND,     
     $                WORK( M+NP+1 ), IWORK, INFO )                        M+NP+3*(N-M)
      IF ( INFO .NE. 0) THEN         
         CALL ERRMSG('DGGGLE DTRCON: argument number IERR wrong',-INFO)
         RETURN
      END IF
         PBPSNM = ONE / (RCOND * TNORM )
*        Estimate norm of A^+_B
         KASE = 0
         CALL DLACON( N, WORK( M+NP+1 ), WORK( M+NP+N+1 ), IWORK, EST,     M+NP+N+N
     $                KASE )
   30    CONTINUE
            CALL DTRSV( 'Upper', 'No transpose', 'Non unit', N-M,
     $                  B( M+1, P-N+M+1 ), LDB, WORK( M+NP+N+M+1 ), 1 )    M+NP+N+N
            CALL DGEMV( 'No transpose', M, N-M, -ONE, B( 1, P-N+M+1 ),
     $                  LDB, WORK( M+NP+N+M+1 ), 1, ONE,
     $                  WORK( M+NP+N+1 ), 1 )
            CALL DTRSV( 'Upper', 'No transpose', 'Non unit', M, A, LDA,
     $                  WORK( M+NP+N+1 ), 1 )                              M+NP+N+M
            DO I = 1, P
               WORK( M+NP+I ) = WORK( M+NP+N+I )
            END DO
            CALL DLACON( M, WORK( M+NP+N+1 ), WORK( M+NP+1 ), IWORK,       M+NP+N+M
     $                   EST, KASE )
            IF( KASE.EQ.0 ) GOTO 40
            CALL DTRSV( 'Upper', 'Transpose', 'Non unit', M, A, LDA,
     $                  WORK( M+NP+1 ), 1 )                                M+NP+M
            CALL DGEMV( 'Transpose', M, N-M, -ONE, B( 1, P-N+M+1 ), LDB,
     $                  WORK( M+NP+1 ), 1, ZERO, WORK( M+NP+M+1 ), 1 )
            CALL DTRSV( 'Upper', 'Transpose', 'Non unit', N-M,
     $                  B( M+1, P-N+M+1 ), LDB, WORK( M+NP+M+1 ), 1 )      M+NP+M+N-M
            DO I = 1, N
               WORK( M+NP+N+I ) = WORK( M+NP+I )
            END DO
            CALL DLACON( N, WORK( M+NP+1 ), WORK( M+NP+N+1 ), IWORK,       M+NP+N+N
     $                   EST, KASE )
            IF( KASE.EQ.0 ) GOTO 40
         GOTO 30
   40    CONTINUE
         ABPSNM = EST
      END IF
*     Estimate norm of (A^+_B)*B
      IF( P+M.EQ.N ) THEN
         EST = ZERO
      ELSE
         KASE = 0
         CALL DLACON( P-N+M, WORK( M+NP+1 ), WORK( M+NP+M+1 ), IWORK,      M+NP+M+P-N+M
     $                EST, KASE )
   50    CONTINUE
*
            IF( P.GE.N ) THEN
               CALL DTRMV( 'Upper', 'No trans', 'Non Unit', M,
     $                     B( 1, P-N+1 ), LDB, WORK( M+NP+M+P-N+1 ), 1 )   M+NP+M+P-N+M
               DO I = 1, M
                  WORK( M+NP+I ) = WORK( M+NP+M+P-N+I )
               END DO
            ELSE
               CALL DGEMV( 'No transpose', N-P, P-N+M, ONE, B, LDB,
     $                  WORK( M+NP+M+1 ), 1, ZERO, WORK( M+NP+1 ), 1 )
               CALL DTRMV( 'Upper', 'No trans', 'Non Unit', P-N+M,
     $                     B( N-P+1, 1 ), LDB, WORK( M+NP+M+1 ), 1 )       M+NP+M+P-N+M
               DO I = N-P+1, M
                  WORK( M+NP+I ) = WORK( M+NP+M-N+P+I )
               END DO
            END IF
            CALL DTRSV( 'Upper', 'No transpose', 'Non unit', M, A, LDA,
     $                  WORK( M+NP+1 ), 1 )                                M+NP+M
            CALL DLACON( M, WORK( M+NP+M+1 ), WORK( M+NP+1 ), IWORK,       M+NP+M+M
     $                   EST, KASE )
*
            IF( KASE.EQ.0 ) GOTO 60
*
            CALL DTRSV( 'Upper', 'Transpose', 'Non unit', M, A, LDA,
     $                  WORK( M+NP+1 ), 1 )                                M+NP+M
            IF( P.GE.N ) THEN
               CALL DTRMV( 'Upper', 'Trans', 'Non Unit', M,
     $                     B( 1, P-N+1 ), LDB, WORK( M+NP+1 ), 1 )         M+NP+M
               DO I = 1, M
                  WORK( M+NP+M+P-N+I ) = WORK( M+NP+I )                    M+NP+M+P-N+M
               END DO
               DO I = 1, P-N
                  WORK( M+NP+M+I ) = ZERO                                  M+NP+M+P-N
               END DO
            ELSE
               CALL DTRMV( 'Upper', 'Trans', 'Non Unit', P-N+M,
     $                     B( N-P+1, 1 ), LDB, WORK( M+NP+N-P+1 ), 1 )     M+NP+M
               DO I = 1, P-N+M
                  WORK( M+NP+M+I ) = WORK( M+NP+N-P+I )                    M+NP+M+P-N+M
               END DO
               CALL DGEMV( 'Transpose', N-P, P-N+M, ONE, B, LDB,
     $                  WORK( M+NP+1 ), 1, ONE, WORK( M+NP+M+1 ), 1 )
            END IF
            CALL DLACON( P-N+M, WORK( M+NP+1 ), WORK( M+NP+M+1 ), IWORK,   M+NP+M+P-N+M
     $                   EST, KASE )
*
            IF( KASE.EQ.0 ) GOTO 60
         GOTO 50
   60    CONTINUE
      END IF
      ABPSBN = EST
*     Get condition numbers and approximate error bounds
      CNDAB = ANORM*ABPSNM
      CNDBA = BNORM*PBPSNM
      IF( PBPSNM.EQ.0.0E+0 ) THEN
*        Then A is square and nonsingular
         XERRBD = EPSMCH*( CNDAB*( ONE+DNORM/(ANORM*XNORM) ) )
         YERRBD = 0.0E+0
      ELSE
         XERRBD = EPSMCH*( CNDAB*( ONE+DNORM/(ANORM*XNORM) ) +
     $                2.0E0*CNDAB*CNDBA*CNDBA*DNORM/(ANORM*XNORM) +
     $                ABPSBN*ABPSBN*PBPSNM*PBPSNM*ANORM*DNORM/XNORM )
         YERRBD = EPSMCH*( ABPSBN*ANORM*PBPSNM*PBPSNM +
     $                PBPSNM*(ANORM*XNORM/DNORM + 2.0E0*CNDBA*CNDBA +
     $                ONE) + CNDBA*PBPSNM )
      END IF
      RETURN
      END
