      SUBROUTINE BKPTWR(N1,
     .                  DATALL,
     .                  N2,
     .                  WRKVEC,
     .                  NAPTS,
     .                  NPTS,
     .                  DOPTS,
     .                  N,
     .                  COVTYPE,
     .                  COVPAR,
     .                  COVMAT,
     .                  LDCOV,
     .                  C0VEC,
     .                  COV0,
     .                  TREND,
     .                  NTREND,
     .                  MUPR,
     .                  LDMPR,
     .                  PHIPR,
     .                  LDPHPR,
     .                  PRINV,
     .                  LDPRIV,
     .                  PHIWRK,
     .                  LDPHWK,
     .                  LONPR,
     .                  LATPR,
     .                  COVBTA,
     .                  LDCVBT,
     .                  CVSRNB,
     .                  NPR,
     .                  TYPPR,
     .                  RSEARCH,
     .                  NSEARCH,
     .                  NSMIN,
     .                  NSMAX,
     .                  FWORK,
     .                  LDFWRK,
     .                  F0WORK,
     .                  DIST,
     .                  INDSNB,
     .                  INDSNW,
     .                  INDSRT,
     .                  KWORK,
     .                  LDKWRK,
     .                  RHSWORK,
     .                  FPWORK,
     .                  FPFWORK,
     .                  FPF0WRK,
     .                  CHLUP,
     .                  LDCLUP,
     .                  CMINV,
     .                  LDCINV, 
     .                  LWORK,
     .                  IPVT,
     .                  IPIV,
     .                  IWORK,
     .                  MODE,
     .                  MU,
     .                  LAMBDA,
     .                  LAMBD0,
     .                  BITS,
     .                  IERR,
     .                  GLSMTH) 

      IMPLICIT NONE
      INTEGER NPTS,N,COVTYPE,TREND,NTREND,NAPTS(*),N1,N2,
     .        NSEARCH,NSMIN,NSMAX,MODE,IERR,INDSNB(*),INDSNW(*),
     .        INDSRT(*),IPIV(*),IPT,LDKWRK,DOPTS(*),
     .        LDCOV,LDFWRK,LDMPR,LDPHPR,LDPHWK,LDPRIV,LDCVBT,LDCLUP,
     .        LDCINV,NPR,TYPPR(*),LWORK,IPVT(*),IWORK(*),GLSMTH,BITS(*)
      DOUBLE PRECISION DATALL(*),WRKVEC(*),
     .                 COVMAT(N,*),C0VEC(*),COV0,
     .                 RSEARCH,FWORK(LDFWRK,*),F0WORK(*),DIST(*),
     .                 KWORK(LDKWRK,*),RHSWORK(*),MU(*),
     .                 LAMBDA(*),
     .                 COVPAR(*),
     .                 FPWORK(LDFWRK,*),FPFWORK(LDFWRK,*),
     .                 FPF0WRK(LDFWRK,*),MUPR(LDMPR,*),
     .                 PHIPR(LDPHPR,*),PHIWRK(LDPHWK,*),LAMBD0,
     .                 LONPR(*),LATPR(*),PRINV(LDPRIV,*),
     .                 COVBTA(LDCVBT,*),
     .                 CHLUP(LDCLUP,*),CMINV(LDCINV,*),
     .                 CVSRNB(LDCOV,*)

c     call wrapper for BKPTS to reduce no of parameters to be passed 
c     from R:
c     DATALL= XPTS + YPTS + ZPTS + VARPTS + LON + LAT + Z
c     length= NPTS   NPTS   NPTS    NPTS     N     N    N
c     WRKVEC= muwrk  beta errbeta dev errdev zsrnb dist  work  ferr berr
c     length=ntrend+ntrend  +1    +n    +1    +n    +n  +lwork  +n   +n

c     debug options
      CHARACTER*16 NAME
      INTEGER DBGLVL
      COMMON /DEBUG/ DBGLVL

      DBGLVL=0

c     there seems to be a problem with large datasets:
c     if R is running with a to low --vsize value the big data vectors DATALL
c     and WRKVEC silently overwrite the following arguments resulting in segfault 
c     or calculating junk. So I put 2 copies of N between DATALL and WRKVEC (N1/N2)
c     if they are destroyed we return quickly with an error message.
c     I don't know why there is no warning from R in this situation, may be some 
c     error in my code is still hidden here. 
c     I tested this with NPTS=2000 vsize=128M .. success
c                             2136   ........... failure (Tru64: NAs, Linux: segfault)
c                             2136       256M .. success   

      IF(((N1.NE.N).OR.(N2.NE.N)).OR.(N1.NE.N2)) THEN
         IERR=1
         CALL ERRMSG('BKGRWR: Fortran subroutine arguments destroyed! In
     .crease vsize! Try to save your workspace before crashing!',107,
     .IERR)
         RETURN
      END IF


      CALL BKPTS(DATALL(1),                                             XPTS
     .            DATALL(NPTS+1),                                            YPTS
     .            DATALL(2*NPTS+1),                                            ZPTS
     .            NAPTS,
     .            DATALL(3*NPTS+1),                                            VARPTS
     .            NPTS,
     .            DOPTS,
     .            DATALL(4*NPTS+1),                                            LON
     .            DATALL(4*NPTS+N+1),                                          LAT
     .            DATALL(4*NPTS+2*N+1),                                        Z
     .            N,
     .            COVTYPE,
     .            COVPAR,
     .            COVMAT,
     .            LDCOV,
     .            C0VEC,
     .            COV0,
     .            TREND,
     .            NTREND,
     .            MUPR,
     .            LDMPR,
     .            PHIPR,
     .            LDPHPR,
     .            PRINV,
     .            LDPRIV,
     .            WRKVEC(1),
     .            PHIWRK,
     .            LDPHWK,
     .            LONPR,
     .            LATPR,
     .            WRKVEC(NTREND+1),
     .            WRKVEC(2*NTREND+1),
     .            COVBTA,
     .            LDCVBT,
     .            WRKVEC(2*NTREND+2),
     .            WRKVEC(2*NTREND+N+2),
     .            CVSRNB, 
     .            WRKVEC(2*NTREND+N+3),
     .            NPR,
     .            TYPPR,
     .            RSEARCH,
     .            NSEARCH,
     .            NSMIN,
     .            NSMAX,
     .            FWORK,
     .            LDFWRK,
     .            F0WORK,
     .            WRKVEC(2*NTREND+2*N+3),
     .            INDSNB,
     .            INDSNW,
     .            INDSRT,
     .            KWORK,
     .            LDKWRK,
     .            RHSWORK,
     .            FPWORK,
     .            FPFWORK,
     .            FPF0WRK,
     .            CHLUP,
     .            LDCLUP,
     .            CMINV,
     .            LDCINV,
     .            WRKVEC(2*NTREND+3*N+3),
     .            LWORK,
     .            IPVT,
     .            WRKVEC(2*NTREND+3*N+LWORK+3),                          = FERR
     .            WRKVEC(2*NTREND+4*N+LWORK+3),                          = BERR
     .            IPIV,
     .            IWORK,
     .            MODE,
     .            MU,
     .            LAMBDA,
     .            LAMBD0,
     .            BITS,
     .            IERR,
     .            GLSMTH)

      RETURN
      END

      SUBROUTINE BKPTS(XPTS,
     .                 YPTS,
     .                 ZPTS,
     .                 NAPTS,
     .                 VARPTS,
     .                 NPTS,
     .                 DOPTS,
     .                  LON,
     .                  LAT,
     .                  Z,
     .                  N,
     .                  COVTYPE,
     .                  COVPAR,
     .                  COVMAT,
     .                  LDCOV,
     .                  C0VEC,
     .                  COV0,
     .                  TREND,
     .                  NTREND,
     .                  MUPR,
     .                  LDMPR,
     .                  PHIPR,
     .                  LDPHPR,
     .                  PRINV,
     .                  LDPRIV,
     .                  MUWRK,
     .                  PHIWRK,
     .                  LDPHWK,
     .                  LONPR,
     .                  LATPR,
     .                  BETA,
     .                  ERRBTA,
     .                  COVBTA,
     .                  LDCVBT,
     .                  DEV,
     .                  ERRDEV,
     .                  CVSRNB,
     .                  ZSRNB,
     .                  NPR,
     .                  TYPPR,
     .                  RSEARCH,
     .                  NSEARCH,
     .                  NSMIN,
     .                  NSMAX,
     .                  FWORK,
     .                  LDFWRK,
     .                  F0WORK,
     .                  DIST,
     .                  INDSNB,
     .                  INDSNW,
     .                  INDSRT,
     .                  KWORK,
     .                  LDKWRK,
     .                  RHSWORK,
     .                  FPWORK,
     .                  FPFWORK,
     .                  FPF0WRK,
     .                  CHLUP,
     .                  LDCLUP,
     .                  CMINV,
     .                  LDCINV,
     .                  WORK,
     .                  LWORK,
     .                  IPVT,
     .                  FERR,
     .                  BERR,
     .                  IPIV,
     .                  IWORK,
     .                  MODE,
     .                  MU,
     .                  LAMBDA,
     .                  LAMBD0,
     .                  BITS,
     .                  IERR,
     .                  GLSMTH)

      IMPLICIT NONE
      INTEGER NPTS,N,COVTYPE,TREND,NTREND,
     .        NSEARCH,NSMIN,NSMAX,MODE,IERR,INDSNB(*),INDSNW(*),
     .        INDSRT(*),IPIV(*),IPT,NAPTS(*),LDKWRK,DOPTS(*),
     .        LDCOV,LDFWRK,LDMPR,LDPHPR,LDPHWK,LDPRIV,LDCVBT,LWORK,
     .        LDCLUP,LDCINV,NPR,TYPPR(*),IPVT(*),IWORK(*),GLSMTH,BITS(*)
      DOUBLE PRECISION XPTS(*),YPTS(*),ZPTS(*),VARPTS(*),
     .                 LON(*),LAT(*),Z(*),COVMAT(LDCOV,*),C0VEC(*),COV0,
     .                 RSEARCH,FWORK(LDFWRK,*),F0WORK(*),
     .                 KWORK(LDKWRK,*),RHSWORK(*),MU(*),
     .                 LAMBDA(*),
     .                 COVPAR(*),
     .                 FPWORK(LDFWRK,*),FPFWORK(LDFWRK,*),
     .                 FPF0WRK(LDFWRK,*),DIST(*),MUPR(LDMPR,*),
     .                 PHIPR(LDPHPR,*),LAMBD0,PHIWRK(LDPHWK,*),
     .                 LONPR(*),LATPR(*),MUWRK(*),PRINV(LDPRIV,*),
     .                 BETA(*),COVBTA(LDCVBT,*),
     .                 WORK(LWORK),
     .                 CHLUP(LDCLUP,*),CMINV(LDCINV,*),DEV(*),
     .                 CVSRNB(LDCOV,*),ZSRNB(*),ERRDEV,ERRBTA,
     .                 FERR(*),BERR(*)


c     subroutine for kriging prediction on a list of given points
c     ...
c     LON,LAT,Z,N      data set
c     X0,Y0,Z0,VAR0    arrays to hold the input/output (grid coords. and 
c                      prediction) for one tile.
c     ...              ... other work arrays to pass through to KRIGE

      DOUBLE PRECISION COVFN
      EXTERNAL COVFN


c     local variables
      INTEGER I,J,K,L, INDDO(1), DO0(1),NA0,usesbbt,pcnt
      DOUBLE PRECISION DELTA, X0, Y0, Z0, VAR0
      CHARACTER*16 NAME

c     constants
      integer dbglvl
      common /DEBUG/ DBGLVL
      dbglvl=0

c     prepare the covariance matrix
      IF (COVTYPE.NE.0) THEN
         DO 1000 I=1,N
            DO 1001 J=I,N
               COVMAT(I,J)=COVFN(COVTYPE,COVPAR,
     .                        SQRT((LON(I)-LON(J))*(LON(I)-LON(J))+
     .                             (LAT(I)-LAT(J))*(LAT(I)-LAT(J))))
               COVMAT(J,I)=COVMAT(I,J)
 1001       CONTINUE
 1000    CONTINUE
      END IF

c     loop over all points and pass them to KRIGE:
      if (bits(1+npts).ne.0) then
         usesbbt=1 
      end if
      PCNT=0
      DO 20 I=1,NPTS
         DO0(1)=DOPTS(I)
         PCNT=PCNT+1
         BITS(I) = PCNT
         X0=XPTS(I)
         Y0=YPTS(I)
c     the main work is now done by KRIGE:
         CALL BK(X0,
     .              Y0,
     .              DO0,
     .              INDDO,
     .              1,
     .              LON,
     .              LAT,
     .              Z,
     .              N,
     .              COVTYPE,
     .              COVPAR,
     .              COVMAT,
     .              LDCOV,
     .              C0VEC,
     .              N,
     .              COV0,
     .              TREND,
     .              NTREND,
     .              MUPR,
     .              LDMPR,
     .              PHIPR,
     .              LDPHPR,
     .              PRINV,
     .              LDPRIV,
     .              MUWRK,
     .              PHIWRK,
     .              LDPHWK,
     .              LONPR,
     .              LATPR,
     .              BETA,
     .              ERRBTA,
     .              COVBTA,
     .              LDCVBT,
     .              DEV,
     .              ERRDEV,
     .              CVSRNB,
     .              ZSRNB,
     .              NPR,
     .              TYPPR,
     .              RSEARCH,
     .              NSEARCH,
     .              NSMIN,
     .              NSMAX,
     .              FWORK,
     .              LDFWRK,
     .              F0WORK,
     .              NTREND,
     .              DIST,
     .              INDSNB,
     .              INDSNW,
     .              INDSRT,
     .              KWORK,
     .              LDKWRK,
     .              RHSWORK,
     .              FPWORK,
     .              FPFWORK,
     .              FPF0WRK,
     .              CHLUP,
     .              LDCLUP,
     .              CMINV,
     .              LDCINV,
     .              WORK,
     .              LWORK,
     .              IPVT,
     .              FERR,
     .              BERR,
     .              IPIV,
     .              IWORK,
     .              MODE,
     .              MU,
     .              NTREND,
     .              Z0,
     .              NA0,
     .              LAMBDA,
     .              N,
     .              LAMBD0,
     .              VAR0,
     .  BITS(npts+2+(pcnt-1)*n),USESBBT,
     .              IERR,
     .              GLSMTH)

c            name="xg\0"
c            call matpr(name,xg,nx,1,nx,dbglvl)
c            name="yg\0"
c            call matpr(name,yg,ny,1,ny,dbglvl)

c           extract results for this tile
               IF (NA0.EQ.1) THEN
                  NAPTS(I)=1
                  ZPTS(I)=0
                  VARPTS(I)=0
c                  write(*,*)"x"
               ELSE
                  ZPTS(I)=Z0
                  VARPTS(I)=VAR0
c                  write(*,*)"o"
c                  VARG(I,J)=IWORK(1)*1.0D0
c                  VARG(I,J)=lambd0
               END IF
c            ELSE
c                  write(*,*)"."

c           extract results for this tile
         ZPTS(I)=Z0
         NAPTS(I)=NA0
         VARPTS(I)=VAR0
 20   CONTINUE

      RETURN
      END
