      SUBROUTINE BKGRID(XSW,
     .                  YSW,
     .                  XNE,
     .                  YNE,
     .                  ANGLE,
     .                  NX,
     .                  NY,
     .                  NZ,
     .                  DX,
     .                  DY,
     .                  XG,
     .                  YG,
     .                  ZG,
     .                  LDZG,
     .                  VARG,
     .                  DOG,
     .                  LON,
     .                  LAT,
     .                  Z,
     .                  EXTRAP,
     .                  N,
     .                  COVTYPE,
     .                  COVPAR,
     .                  C0VEC,
     .                  COV0,
     .                  COVMAT,
     .                  LDCOV,
     .                  EXTCOV,
     .                  TREND,
     .                  NTREND,
     .                  MUPR,
     .                  LDMPR,
     .                  PHIPR,
     .                  LDPHPR,
     .                  MUWRK,
     .                  PHIWRK,
     .                  LDPHWK,
     .                  LONPR,
     .                  LATPR,
     .                  BETA,
     .                  ERRBTA,
     .                  COVBTA,
     .                  LDCVBT,
     .                  DEV,
     .                  ERRDEV,
     .                  CVSRNB,
     .                  ZSRNB,
     .                  NPR,
     .                  TYPPR,
     .                  RSEARCH,
     .                  NSEARCH,
     .                  NSMIN,
     .                  NSMAX,
     .                  FWORK,
     .                  FWRK2,
     .                  LDFWRK,
     .                  F0WORK,
     .                  DIST,
     .                  INDSNB,
     .                  INDSNW,
     .                  INDSRT,
     .                  KWORK,
     .                  LDKWRK,
     .                  RHSWORK,
     .                  FPWORK,
     .                  FPFWORK,
     .                  FPF0WRK,
     .                  CHLUP,
     .                  LDCLUP,
     .                  CMINV,
     .                  LDCINV,
     .                  WORK,
     .                  LWORK,
     .                  IPVT,
     .                  FERR,
     .                  BERR,
     .                  IPIV,
     .                  IWORK,
     .                  MODE,
     .                  MU,
     .                  LAMBDA,
     .                  LDLMBD,
     .                  LAMBD0,
     .                  BITS,
     .                  IERR,
     .                  RETLM,
     .                  GLSMTH)
      IMPLICIT NONE
      INTEGER NX,NY,NZ,N,COVTYPE,TREND,NTREND,LDZG,RETLM,
     .        NSEARCH,NSMIN,NSMAX,MODE,IERR,INDSNB(*),INDSNW(*),
     .        INDSRT(*),IPIV(*),IPT,EXTRAP,DOG(NX,*),LDKWRK,EXTCOV,
     .        LDCOV,LDFWRK,LDMPR,LDPHPR,LDPHWK,LDCVBT,LWORK,LDLMBD,
     .        LDCLUP,LDCINV,NPR,TYPPR(*),IPVT(*),IWORK(*),GLSMTH,BITS(*)
      DOUBLE PRECISION XSW,YSW,XNE,YNE,ANGLE,DX,DY,
     .                 XG(*),YG(*),ZG(LDZG,*),VARG(LDZG,*),
     .                 LON(*),LAT(*),Z(*),COVMAT(LDCOV,*),C0VEC(*),COV0,
     .                 RSEARCH,FWORK(LDFWRK,*),F0WORK(*),
     .                 KWORK(LDKWRK,*),RHSWORK(*),MU(NTREND,*),
     .                 LAMBDA(LDLMBD,*),FWRK2(LDFWRK,*),
     .                 COVPAR(*),
     .                 FPWORK(LDFWRK,*),FPFWORK(LDFWRK,*),
     .                 FPF0WRK(LDFWRK,*),DIST(*),MUPR(LDMPR,*),
     .                 PHIPR(LDPHPR,*),LAMBD0(LDZG,*),PHIWRK(LDPHWK,*),
     .                 LONPR(*),LATPR(*),MUWRK(*),
     .                 BETA(*),COVBTA(LDCVBT,*),
     .                 WORK(LWORK),
     .                 CHLUP(LDCLUP,*),CMINV(LDCINV,*),DEV(*),
     .                 CVSRNB(LDCOV,*),ZSRNB(*),ERRDEV,ERRBTA,
     .                 FERR(*),BERR(*)



c     subroutine for kriging prediction on a grid
c     
c     This subroutine takes the grid specification and calls KRIGE
c     (see below) on the grid points.
c
c     
c            [1,1]                              ne       
c              +-------------------------------+    
c              | o   o   o   o   o   o   o   o |      o    -- grid points (i,j)
c              |(1,1)                       x  |    
c              | o   o   o   o   o   o   o   o |    
c              |                               |    
c              | o   o   o   o   o   o   o   o |    
c              |                               |    
c              | o   o   o   o   o   o   o   o |      x    -- user specified
c              |                               |_             sw/ne corners
c       N      | o   o   o   o   o   o   o   o | \ 
c        +     |                               |  > dy
c         \    | o   o   o   o   o   o   o   o |_/
c          \   |                               |    
c           \  | o   o   o   o   o   o   o   o |     
c            \ |  x                     (ny,nx)|         
c             \| o   o   o   o   o   o   o   o |    
c              +-------------------------------+
c            sw                  \_ _/               
c                                  v
c                                   dx
c     parameters
c     XSW,YSW          lon/lat of sw-corner
c     XNE,YNE          lon/lat of ne-corner
c     ANGLE            angle to add to N-S 
c     NX,NY            no. of grid points in x / y direction (at least 2)
c     NZ               overall no of grid points (=NX*NY)
c     XG,YG,ZG,VARG    arrays to hold the output (grid coords. and 
c                      prediction)
c     LON,LAT,Z,N      data set
c     X0,Y0,Z0,VAR0    arrays to hold the input/output (grid coords. and 
c                      prediction) for one tile.
c     ...              ... other work arrays to pass through to KRIGE

      DOUBLE PRECISION COVFN
      EXTERNAL COVFN

c     local variables
      INTEGER I,J,K,L, INDDO(1), DO0(1), NA0, usesbbt, pcnt
      DOUBLE PRECISION DELTA, X0, Y0, Z0, VAR0,DST, L0

c     debug options
      CHARACTER*16 NAME
      INTEGER DBGLVL
      COMMON /DEBUG/ DBGLVL

      dbglvl=0

c     build/check grid parameters:
      IF (NX*NY.NE.NZ) THEN
         IERR=1
         CALL ERRMSG('BKGRID: wrong value of nz (should be nx*ny)',45,
     .               IERR)
         RETURN
         END IF

c      IF (NX.GE.2 .AND. DX.EQ.0) THEN 
c         DX=(XNE-XSW)/(NX-1)
c         write (*,*)dy
c      ELSE IF (DX.GE.0) THEN
c         NX=AINT((XNE-XSW)/DX)+1
c         DELTA=XSW+NX*DX-XNE
c         XSW=XSW-DELTA/2
c         XNE=XNE+DELTA/2
c      ELSE
c         write(*,*) "wrong x dimension of grid"
c         IERR=1
c         RETURN
c      END IF
c
c      IF (NY.GE.2 .AND. DY.EQ.0) THEN 
c         DY=(YNE-YSW)/(NY-1)
c         WRITE (*,*)DY
c      ELSE IF (DY.GE.0) THEN
c         NY=AINT((YNE-YSW)/DY)+1
c         DELTA=YSW+NY*DY-YNE
c         YSW=YSW-DELTA/2
c         YNE=YNE+DELTA/2
c      ELSE
c         write(*,*) "wrong y dimension of grid"
c         IERR=1
c         RETURN
c      END IF

c      IF (NTX.GE.1) THEN 
c         ITX=INT(NX/NTX)+1
c      ELSE IF (ITX.GE.0) THEN
c         NTX=INT(NX/ITX)+1
c      ELSE
c         write(*,*) "wrong x dimension of tiles"
c         IERR=1
c         RETURN
c      END IF

c      IF (NTY.GE.1) THEN 
c         ITY=INT(NY/NTY)+1
c      ELSE IF (ITY.GE.0) THEN
c         NTY=INT(NY/ITY)+1
c      ELSE
c         write(*,*) "wrong y dimension of tiles"
c         IERR=1
c         RETURN
c      END IF
c         write(*,*)"dx,dy:",dx,dy
      DO 1 I=1,NY
         YG(I)=YSW+DY*(I-1)
 1    CONTINUE
      DO 2 J=1,NX
         XG(J)=XSW+DX*(J-1)
 2    CONTINUE
c      name="xg\0"
c      call matpr(name,xg,nx,1,nx,dbglvl)
c      name="yg\0"
c      call matpr(name,yg,ny,1,ny,dbglvl)

c     prepare the covariance matrix
      IF (COVTYPE.NE.0) THEN
       IF (EXTCOV.NE.1) THEN
         DO 1000 I=1,N
            DO 1001 J=I,N
               DST=SQRT((LON(I)-LON(J))*(LON(I)-LON(J))+
     .                  (LAT(I)-LAT(J))*(LAT(I)-LAT(J)))
               COVMAT(I,J)=COVFN(COVTYPE,COVPAR,DST)
c               if (dst.eq.0.0D0) write(*,*)i,j,dst
               COVMAT(J,I)=COVMAT(I,J)
 1001       CONTINUE
 1000    CONTINUE
       END IF
      ELSE
         IERR=1
         CALL ERRMSG('BKGRID: no covariance type specified!',38,
     $   IERR)
         RETURN
      END IF
c     rotation:
c     call drotg(nz,xgwork,1,ygwork,1,COS(ALPHA),SIN(ALPHA))
c     loop over all points and pass them to KRIGE:
      if (retlm.eq.1) then
         PCNT=0
         usesbbt=1 
      else
         PCNT=1
         usesbbt=0 
      end if
      DO 20 I=1,NX
         DO 10 J=1,NY
            if (retlm.eq.1) then
               PCNT=PCNT+1
               BITS(I+NY*(J-1)) = PCNT
            end if
            X0=XG(I)
            Y0=YG(J)
            DO0(1)=DOG(I,J)
c            write(*,*),i,j
c           the main work is now done by BK:
            IF (DO0(1).EQ.1) THEN
               INDDO(1)=1
               CALL BK(X0,
     .                 Y0,
     .                 DO0,
     .                 INDDO,
     .                 1,
     .                 LON,
     .                 LAT,
     .                 Z,
     .                 N,
     .                 COVTYPE,
     .                 COVPAR,
     .                 COVMAT,
     .                 LDCOV,
     .                 C0VEC,
     .                 N,
     .                 COV0,
     .                 TREND,
     .              NTREND,
     .              MUPR,
     .              LDMPR,
     .              PHIPR,
     .              LDPHPR,
     .              MUWRK,
     .              PHIWRK,
     .              LDPHWK,
     .              LONPR,
     .              LATPR,
     .              BETA,
     .              ERRBTA,
     .              COVBTA,
     .              LDCVBT,
     .              DEV,
     .              ERRDEV,
     .              CVSRNB,
     .              ZSRNB,
     .              NPR,
     .              TYPPR,
     .              RSEARCH,
     .              NSEARCH,
     .              NSMIN,
     .              NSMAX,
     .              FWORK,
     .              FWRK2,
     .              LDFWRK,
     .              F0WORK,
     .              NTREND,
     .              DIST,
     .              INDSNB,
     .              INDSNW,
     .              INDSRT,
     .              KWORK,
     .              LDKWRK,
     .              RHSWORK,
     .              FPWORK,
     .              FPFWORK,
     .              FPF0WRK,
     .              CHLUP,
     .              LDCLUP,
     .              CMINV,
     .              LDCINV,
     .              WORK,
     .              LWORK,
     .              IPVT,
     .              FERR,
     .              BERR,
     .              IPIV,
     .              IWORK,
     .              MODE,
     .              MU(1,pcnt),
     .              NTREND,
     .              Z0,
     .              NA0,
c     .              LAMBDA,
     .              LAMBDA(1,pcnt),
     .              N,
     .              L0,
c     .              LAMBD0(pcnt),
     .              VAR0,
     .              BITS(1+(pcnt-1)*n),
     .              USESBBT,
     .              IERR,
     .              GLSMTH)
c            name="xg\0"
c            call matpr(name,xg,nx,1,nx,dbglvl)
c            name="yg\0"
c            call matpr(name,yg,ny,1,ny,dbglvl)

c           extract results for this tile
               IF (NA0.EQ.1) THEN
                  DOG(I,J)=-1
                  ZG(I,J)=0
                  VARG(I,J)=0
                  if (retlm.eq.1) then
                     LAMBD0(I,J)=0
                  end if
c                  write(*,*)"x"
               ELSE
                  ZG(I,J)=Z0
                  VARG(I,J)=VAR0
                  if (retlm.eq.1) then
                     LAMBD0(I,J)=L0
                  end if
c                  write(*,*)"o"
c                  VARG(I,J)=IWORK(1)*1.0D0
c                  VARG(I,J)=lambd0
               END IF
c            ELSE
c                  write(*,*)"."
            END IF
 10      CONTINUE
 20   CONTINUE

      RETURN
      END


