\name{empirical.prior}
\alias{empirical.prior}
\title{ Collect prior knowledge about trend parameters from historical
  data }
\description{
  This function extracts prior knowlegde about trend parameters from
  datasets. It takes a given variogram model and performs GLS according
  to the given formula. 
}
\usage{
empirical.prior(x, formula=NULL, var.mod=NULL, prior=NULL, method="gqr", namx=NULL, namy=NULL)
}
\arguments{
  \item{x}{ data set (data.frame) }
  \item{formula}{ linear model for trend function }
  \item{var.mod}{ underlying variogram model, fitted with \code{\link[sgeostat]{fit.variogram}} }
  \item{prior}{ optional, already existing \code{\link{bk.prior}} object
  to which actual output should be added}
  \item{method}{ see \code{\link{glsfit}} }
  \item{namx}{ name of x coordinate, only needed for constant trend model. }
  \item{namy}{ see above. }
}
\details{
  It is possible to call \code{empirical.prior} repeatedly to accumulate
   the prior knpwledge of several datasets in the returned object.
}
\value{
  An object of type \code{\link{bk.prior}}.
}
\references{ ftp://ftp-stat.uni-klu.ac.at/pub/R/contrib }
\author{ A. Gebhardt <agebhard@uni-klu.ac.at> }
\note{ Uses LAPACK routine DGGGLM. }


\seealso{ \code{\link{bk.grid}},\code{\link{bk.tiles}},\code{\link{bk.points}} }

\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
}
# need some preparation steps using sgeostat functions
  require(rgeostat)
# the data set
  if(length(ls(pat="leman.78"))==0)data(leman)
  if(length(ls(pat="leman.bank"))==0)data(leman.bank)
# data(leman) contains three measurement grids:
# 1978, 1983, 1988
# generate the point objects:
  if(length(ls(pat="leman.78.pt"))==0) leman.78.pt<-point(leman.78)
  if(length(ls(pat="leman.83.pt"))==0) leman.83.pt<-point(leman.83)
  if(length(ls(pat="leman.88.pt"))==0) leman.88.pt<-point(leman.88)
# use 1988 data for variogram estimation, star with pairs
  if(length(ls(pat="leman.88.pr.30"))==0)
    leman.88.pr.30<-pair(leman.88.pt,maxdist=30)
# do the estimation
  if(length(ls(pat="leman.88.ev30"))==0)
    leman.88.ev30<-est.variogram(leman.88.pt,leman.88.pr.30,"cadpbm")
# fit a sperical variogram
  if(length(ls(pat="leman.88.vmsph"))==0)
    leman.88.vmsph<-fit.variogram("spherical",leman.88.ev30,0.1,0.2,25,plot.it=TRUE)
plot(leman.88.ev30,var.mod.obj=leman.88.vmsph)



# now prepare the prior guesses:
# simple linear trend
leman.prior.1<-empirical.prior(leman.83,cadpbm~x+y,leman.88.vmsph,duplicate="mean")

leman.prior.1<-empirical.prior(leman.78,cadpbm~x+y,leman.88.vmsph,prior=leman.prior.1,duplicate="mean")

# or constant mean model
leman.prior.0<-empirical.prior(leman.83,cadpbm~1,leman.88.vmsph,duplicate="mean",namx="x",namy="y")

leman.prior.0<-empirical.prior(leman.78,cadpbm~1,leman.88.vmsph,prior=leman.prior.0,duplicate="mean",namx="x",namy="y")

# (some outliers have to be removed:)
#leman.prior<-empirical.prior(x = leman.83[-c(69,209),],
#                             formula = cadpbm ~ x + y + 1,
#                             var.mod=leman.sph, duplicate="mean")
#leman.prior<-empirical.prior(x = leman.78[-c(69,208),],
#                             formula = cadpbm ~ x + y + 1,
#                             var.mod=leman.sph, prior=leman.prior,
#                             duplicate="mean")
}
\keyword{ baykrig }
