glsfit.workquery <- function(n,ntrend,method){
  
  if(method==1 || method==0){
    # get optimum block sizes:
    lwork.query <- .Fortran("dsysvq",
                            n=as.integer(n),
                            nrhs=as.integer(n),
                            a=double(n*n),  
                            lda=as.integer(n),
                            af=double(n*n),  
                            ldaf=as.integer(n),
                            ipiv=integer(n),
                            b=double(n*n),
                            ldb=as.integer(n),
                            x=double(n*n),
                            ldx=as.integer(n),
                            rcond=double(1),
                            ferr=double(n),
                            berr=double(n),
                            work=double(1),       # <- contains opt lwork on ret
                            lwork=as.integer(-1), # <- query for optimum lwork
                            iwork=integer(n),
                            info=integer(1)
                            )
    lwork.query2 <- .Fortran("dgggle",
                            n=as.integer(n),
                            m=as.integer(ntrend),
                            p=as.integer(n),  
                            a=double(n*ntrend),   # not referenced
                            lda=as.integer(n),    #
                            b=double(n*n),        #
                            ldb=as.integer(n),    #
                            d=double(n),          #
                            x=double(ntrend),     #
                            y=double(n),          #
                            xerr=double(ntrend),  #
                            yerr=double(n),       #
                            work=double(1),       # <- contains opt lwork on ret
                            lwork=as.integer(-1), # <- query for optimum lwork
                            iwork=integer(1),     # not referenced  
                            info=integer(1)
                            )
    if(lwork.query2$work[1]>lwork.query$work[1]) lwork.query<-lwork.query2
  }
  if(method==2){
    # get optimum block sizes for inverting a n x n matrix:
    lwork.query <- .Fortran("dsysvq",
                            n=as.integer(n),
                            nrhs=as.integer(n),
                            a=double(n*n),  
                            lda=as.integer(n),
                            af=double(n*n),  
                            ldaf=as.integer(n),
                            ipiv=integer(n),
                            b=double(n*n),
                            ldb=as.integer(n),
                            x=double(n*n),
                            ldx=as.integer(n),
                            rcond=double(1),
                            ferr=double(n),
                            berr=double(n),
                            work=double(1),     # <- contains opt lwork on ret
                            lwork=as.integer(-1), # <- query for optimum lwork
                            iwork=integer(n),
                            info=integer(1)
                            )
  }
  lwork.query$work[1]
}

