glsfit<-function(formula,x,covmat=NULL,method="direct", duplicate = "error", dupfun = NULL){
  if(method!="direct" && method !="gqr" && method!="ols")
    stop("method should be one of \"gqr\", \"ols\" or \"direct\"")
  
  method<-switch(method,direct=2,gqr=1,ols=0)
  
  if(!is.data.frame(x))stop("x is not a data frame!")
  p <- dim(x)[2]

  if(is.null(formula))stop("formula not given!")
  ft<-terms(formula)
  vars<-attr(ft,"variables")
  fmat<-model.matrix.default(formula, data=x)
  
  namz<-as.character(vars[2])
  ntrend<-dim(fmat)[2]
  z<-x[,namz]

  # eliminate duplicates:
  xy <- paste(x[,-match(namz,colnames(x))][,1],x[,-match(namz,colnames(x))][,2], sep =",")
  idup <- match(xy, xy)
  if(duplicated(idup)){
      if(duplicate=="user" && !is.function(dupfun))
          stop("duplicate=\"user\" requires dupfun to be set to a function")
      if(duplicate!="error")
      {
          centre <- function(x) {
              switch(duplicate,
                     mean = mean(x),
                     median = median(x),
                     user = dupfun(x))
          }
         if(duplicate!="strip"){
              z <- unlist(lapply(split(z,idup), centre))
              ord <- !duplicated(xy)
              fmat<-fmat[ord,]
          }
          else{
              ord <- (hist(idup,plot=F,freq=T,breaks=seq(0.5,max(idup)+0.5,1))$counts==1)
              fmat<-fmat[ord,]
              z <- z[ord]
              
          }
      }
      else
          if(any(duplicated(fmat)))
              stop("duplicate data points")
  }
  n <- dim(fmat)[1]
  if(is.null(n)){
    n<-length(fmat)
    if(is.null(n))
      stop("error: n not known!")
  }
  
  if(is.null(covmat) || method==0)
    covmat<-diag(rep(1,n))
  ldc<-dim(covmat)[1]
  cat(paste("ldc is ",ldc,"\n"))

  # determine optimum array sizes:
  lwork <- glsfit.workquery(n,ntrend,method)

  cat(paste("optimales lwork:",lwork,"\n"))

#  if(method==0)method<-1
  
  # do the fit:
  ans<-.Fortran("glsfit",
                fmat=as.double(fmat),
                fmat2=as.double(fmat),
                n=as.integer(n),
                ntrend=as.integer(ntrend),
                ldf=as.integer(n),
                y=as.double(z),
                covmat=as.double(covmat),
                ldc=as.integer(ldc),
                beta=double(ntrend),
                errbeta=double(1),
                dev=double(n),
                errdev=double(1),
                covbta=double(ntrend*ntrend),
                ldcovbta=as.integer(ntrend),
                sgsqr=double(1),
                chlup=double(n*n),
                ldchlup=as.integer(n),
                cminv=double(n*n),
                ldcinv=as.integer(n),
                cwork=double(n*n),
                ldcwork=as.integer(n),
                cwork2=double(n*n),
                ldcwork2=as.integer(n),
                forwarderr=double(n),
                backwarderr=double(n),
                work=double(lwork),
                lwork=as.integer(lwork),
                ipvt=integer(ntrend),
                ipiv=integer(n),
                iwork=integer(3*n),
                info=integer(1),
                method=as.integer(method)
                )
  
  tlab<-attr(ft,"term.labels")
  if(attr(ft,"intercept")==1) tlab<-c("(Intercept)",tlab)
  ret<-list(est=ans$beta,
            est.relerr=ans$errbeta,
            cov=matrix(ans$covbta,ntrend,ntrend),
            residuals=ans$dev,
            residuals.relerr=ans$errdev,
            data=x,
            formula=formula,
            call=match.call(),
            covmat=covmat,
            sigma.squared=ans$sgsqr)
  names(ret$est)<-tlab
  rownames(ret$cov)<-tlab
  colnames(ret$cov)<-tlab
  ret$predict<-z-ret$residuals
  class(ret)<-"glsfit"
  ret
}

print.glsfit <- function(obj)
  {
    if (!inherits(obj, "glsfit")) 
      stop("obj must be of class \"glsfit\"")
    cat("\n")
    cat("Call:\n")
    print(obj$call)
    cat("\n")
    cat("Coefficients:\n")
    print(obj$est)
    cat("\n")
    cat("Covariance of Estimation:\n")
    print(obj$cov)
  }
