"empirical.prior" <-
  function (x, formula=NULL, var.mod=NULL, prior=NULL, method="gqr", 
            namx=NULL,namy=NULL, duplicate = "error", dupfun = NULL)
{
  n <- dim(x)[1]
  if(is.null(formula))stop("formula not given!")
  if((!is.null(prior)) && !inherits(prior,"bk.prior"))
    stop("class of \"prior\" ist wrong!")
  
  ret <- list()
  ret$formula<-formula
  ft<-terms(formula)
  ret$variables<-attr(ft,"variables")
  ret$ntr<-dim(model.matrix(object=formula,data=x))[2]
           
  if(length(ret$variables)!=4 & length(ret$variables)!=2) stop("need 1 or 3 variables (\"z ~ f(x, y)\" or \"z ~ 1\")  in formula!")
  if(length(ret$variables)==4){
    namx<-as.character(ret$variables[3])
    namy<-as.character(ret$variables[4])
  } else {
    if(is.null(namx) || is.null(namy))
      stop("no x and/or y names given, needed for constant mean!")
  }

  namz<-as.character(ret$variables[2])

  # eliminate duplicates:
  xy <- paste(x[,namx], x[,namy], sep =",")
  idup <- match(xy, xy)
  if(duplicate=="user" && !is.function(dupfun))
    stop("duplicate=\"user\" requires dupfun to be set to a function")
  if(duplicate!="error")
    {
      centre <- function(x) {
        switch(duplicate,
               mean = mean(x),
               median = median(x),
               user = dupfun(x))
      }
      if(duplicate!="strip"){
        znew <- unlist(lapply(split(x[,namz],idup), centre))
        ord <- !duplicated(xy)
        x <- x[ord,]
        x[,namz]<-znew
        n <- dim(x)[1]
      }
      else{
        ord <- (hist(idup,plot=FALSE,freq=TRUE,breaks=seq(0.5,max(idup)+0.5,1))$counts==1)
        x <- x[ord,]
        n <- dim(x)[1]
      }
      }
    else
      if(any(duplicated(xy)))
        stop("duplicate data points")

  if(!is.null(var.mod)){
    c0 <- var.mod$parameters[1]+var.mod$parameters[2]      
    xx.dist<-as.matrix(dist(cbind(x[,namx], x[,namy]),
                            diag=TRUE,upper=TRUE))
    covmat <- c0-var.mod$model(xx.dist,var.mod$parameters)
  }
  else
    covmat <- diag(1,n)

  x.glsfit<-glsfit(formula,as.data.frame(x),covmat=covmat,method=method, duplicate=duplicate)

#    pmean <- c(pmean, x.glsfit$beta)
    
#    pvar <- c(pvar, x.glsfit$vbeta)
  #nur ok, kein gls
#    pmean[,i] <- c(mean(args[[i]][,namz]))
#    pvar[,i] <- c(matrix(var(args[[i]][,namz])/nx[i],1,1))

  if(is.null(prior)){
    ret$n <- 1
    ret$namx <- namx
    ret$namy <- namy
    ret$namz <- namz
    ret$formula <- formula
    ret$mu  <- list(x.glsfit$est)
    ret$phi <- list(x.glsfit$cov)
    ret$phiinv <- list(solve(x.glsfit$cov))
    ret$lon <- mean(x[,namx])
    ret$lat <- mean(x[,namy])
    ret$type<-"empirical"
    ret$info<-dim(x)[1]
    ret$call<-match.call()
  } else {
    ret$n <- prior$n + 1
    ret$mu <- prior$mu
    ret$mu[[prior$n + 1]]  <- x.glsfit$est
    ret$phi <- prior$phi
    ret$phi[[prior$n + 1]] <- x.glsfit$cov
#    ret$phiinv <- prior$phiinvv
#    ret$phiinv[[prior$n + 1]] <- solve(x.glsfit$cov)
    ret$lon <- c(prior$lon,mean(x[,namx]))
    ret$lat <- c(prior$lat,mean(x[,namy]))
    ret$type<-c(prior$type,"empirical")
    ret$info<-c(prior$info,dim(x)[1])
    ret$call<-c(prior$call,match.call())
  }  
  class(ret)<-"bk.prior"
  ret
}
