stat.ma                 package:sma                 R Documentation

_C_a_l_c_u_l_a_t_i_o_n _o_f _l_o_g _I_n_t_e_n_s_i_t_y _R_a_t_i_o_s _a_n_d _A_v_e_r_a_g_e _l_o_g _I_n_t_e_n_s_i_t_i_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     Computes the log intensity ratio M = log_2 (R/G) and the mean log
     intensity A = log_2(R*G)/2, where R and G represent the
     fluorescence intensities in the red and green channels,
     respectively. Logarithms base 2 are used instead of natural or
     decimal logarithms as intensities are typically integers between 1
     and 2^{16}. The log intensity ratios M are normalized using one of
     the five available methods.

_U_s_a_g_e:

     stat.ma(RG, layout, norm="p", pout=F, ...)

_A_r_g_u_m_e_n_t_s:

      RG: a list with 4 elements, each represents a matrix with p rows
          for p genes and n columns for n slides. 
          The first element "R" contains the raw red intensities from
          slide i=1,...,n .
          Similarly, the second element "G" contains the raw green
          intensities. 
          The third element "Rb"  contains the background red
          intensities and 
          the fourth element "Gb" contains the  background green
          intensities.
          This list structure can be generated by the interactive
          function `init.data'. 

  layout: a list specifying the dimensions of the spot matrix and the
          grid   matrix.  This can be generated by calling `init.grid'.

    norm: Character string, one of "n", "m", "l", "p" or "s".  This
          argument specifies the type of normalization method to be
          performed: "n" no normalization between the 2 channels; "m"
          `median' normalization, which sets the median of log
          intensity ratios to zero; "l" global `lowess' normalization;
          "p" print-tip group lowess normalization and "s" scaled
          print-tip group lowess normalization. The default method is
          set to print-tip normalization.

    pout: if TRUE, an M vs. A plot will be produced.  Otherwise, a
          matrix of log intensity ratios and average log intensities is
          returned. 

     ...: other parameters used in `ma.func'. 

_V_a_l_u_e:

     List containing the following components:

       M: Matrix of log expression ratios M = log_2 (R/G)

       A: Matrix of average log intensities A = log_2(R*G)/2

     For the matrix in each of the components, rows correspond to genes
     and columns correspond to different hybridizations, that is
     different slides.

_N_o_t_e:

     `ma.func', `norm.l.func', `norm.scale.func' and `norm.pin.func'
     are called by `stat.ma' and are not typically used on their own.

_A_u_t_h_o_r(_s):

     Yee Hwa Yang, yeehwa@stat.berkeley.edu 
     Sandrine Dudoit, sandrine@stat.berkeley.edu 
     Natalie Roberts, nroberts@wehi.edu.au

_R_e_f_e_r_e_n_c_e_s:

     S. Dudoit, Y. H. Yang, M. J. Callow, and T. P. Speed. Statistical
     methods for identifying differentially expressed genes in
     replicated cDNA microarray experiments (Statistics, UC Berkeley,
     Tech Report # 578).

_S_e_e _A_l_s_o:

     `ma.func', `norm.l.func', `norm.pin.func', `norm.scale.func',
     `plot.mva', `lowess'.

_E_x_a_m_p_l_e_s:

     data(MouseArray)
     ## mouse.setup <- init.grid() 
     ## mouse.data <- init.data() ## see \emph{init.data} 
     mouse.lratio <- stat.ma(mouse.data, mouse.setup)

