###--- >>> `hclust' <<<----- Hierarchical Clustering

	## alias	 help(hclust)
	## alias	 help(plot.hclust)
	## alias	 help(print.hclust)

##___ Examples ___:

library(mva)
data(USArrests)
hc <- hclust(dist(USArrests), "ave")
plot(hc)
plot(hc, hang=-1)

## Do the same with centroid clustering and squared Euclidean distance,
## cut the tree into ten clusters and reconstruct the upper part of the
## tree from the cluster centers.
hc <- hclust(dist(USArrests)^2, "cen")
memb <- cutree(hc, k=10)
cent <- NULL
for(k in 1:10){
  cent <- rbind(cent, apply(USArrests[memb==k,,drop=FALSE], 2, mean))
}
hc1 <- hclust(dist(cent)^2, method="cen", members=table(memb))
opar <- par(mfrow=c(1,2))
plot(hc,  labels=FALSE, hang=-1, main= "Original Tree")
plot(hc1, labels=FALSE, hang=-1, main= "Re-start from 10 clusters")
par(opar)

## Keywords: 'multivariate', 'cluster'.


