###--- >>> `gafit' <<<----- Genetic Algorithm for Curve Fitting

	## alias	 help(gafit)

##___ Examples ___:

# Single parameter, all real numbers
e <- expression( cos( theta ) + sin( theta ))
gafit( e, list( theta=3 ), step=0.1 )  # usually gets close to 3.926991

# Double parameter, complex numbers
sumsq <- function( x ) { sum(( Mod( x )) ^ 2 )}
freq <- exp( 1:15 )
tpj <- 2 * pi * (0+1i)
data <- 1 / ( 10 + tpj * freq * 1e-3 )
e <- expression( sumsq( 1 / ( R + tpj * freq * C ) - data ))
gafit( e, list( R=100, C=1e-6 ), step=0.1, maxiter=100 )


## Keywords: 'nonlinear', 'regression'.


