###--- >>> `fdim' <<<----- Calculation of generalizated fractal dimension of Data-Sets.

	## alias	 help(fdim)

##___ Examples ___:

#Example 1
library(fdim)
data <- makeline(10000,3,100)           # Build a data-set if the user doesn't has it.
df <- fdim(data,q=0,Alpha=0.3)          # Calculation of fractal dimension
print (df$fdim)                         # Show us the q-dimension value.
print (df)                              # Show us relevant information about the estimated
                                        # fractal dimension.

plot(df$allpoints)                      # make a plot in order to see the ipoints individually
abline(coef(df),col=2)                  # draw a line in order to see the correlation
                                        # If we think the confidence criteria must be changed ...
df2 <- slopeopt(as.matrix(df$allpoints),Alpha=0.5)
summary(df2)                            # Show us the quality of the approach.

#Example 2
data <- makessphere(1000)               #Build a data-set with points making a Sphere Surface
if (require(xgobi)) xgobi(data)         #Show data      
df <- fdim(data,q=0,Alpha=0.2,PlotF=TRUE)       # Calculation of fractal dimension
print(df$fdim)                          #Fractal Dimension

## Keywords: 'robust'.


