###--- >>> `plot.ts' <<<----- Plotting Time-Series Objects

	## alias	 help(plot.ts)
	## alias	 help(plot.mts)
	## alias	 help(lines.ts)

##___ Examples ___:


## Multivariate
z <- ts(matrix(rt(300, df = 3), 100, 3), start=c(1961, 1), frequency=12)
plot(z)                # multiple
plot(z, panel=points)  # same with points instead of lines
plot(z, plot.type="single", lty=1:3)

## A phase plot:
data(nhtemp)
plot(nhtemp, c(nhtemp[-1], NA), cex = .8, col="blue",
     main = "Lag plot of New Haven temperatures")
## a clearer way to do this would be
##Don't run: library(ts)
##D plot(nhtemp, lag(nhtemp, 1), cex = .8, col="blue",
##D      main = "Lag plot of New Haven temperatures")


library(ts)

data(sunspots)
## xy.lines and xy.labels are FALSE for large series:
plot(lag(sunspots, 1), sunspots, pch = ".")

data(EuStockMarkets)
SMI <- EuStockMarkets[, "SMI"]
plot(lag(SMI,  1), SMI, pch = ".")
plot(lag(SMI, 20), SMI, pch = ".", log = "xy",
     main = "4 weeks lagged SMI stocks -- log scale", xy.lines= TRUE)

detach("package:ts") 

## Keywords: 'hplot', 'ts'.


