###--- >>> `budget' <<<----- Optimal sampling design for 2-stage studies with fixed budget

	## alias	 help(budget)

##___ Examples ___:


##Don't run: We give an example using the pilot subsample from the CASS data 
##D discussed in Reilly(1996). The data are in the cass2 matrix, which can be loaded using

data(cass2)

##Don't run: and a description of the dataset can be seen using

help(cass2)

##Don't run: In our examples below, we use sex and weight as auxiliary variables.
##D 
##D Given an available budget of 10,000, a first-stage cost of  1/unit
##D and second-stage cost  0.5/unit, the codes below will calculate
##D the sampling strategy that optimises the precision of the 
##D coefficient for SEX : see output below.

data(cass2)
y_cass2[,1]            #response variable
z_cass2[,10]           #auxiliary variable
x_cass2[,c(2,4:9)]     #predictor variables

# run CODING function to see in which order we should enter prevalences
coding(x=x,y=y,z=z)     
# supplying the prevalence (from Table 5, Reilly 1996)

prev_c(0.0197823937,0.1339020772,0.6698813056,0.0544015826,
+ 0.0503214639,0.0467359050,0.0009891197,0.0040801187,0.0127349159,
+ 0.0022255193,0.0032146390,0.0017309594)

# optimise sex coefficient

budget(x=x,y=y,z=z,var="sex",prev=prev,b=10000,c1=1,c2=0.5)


##Don't run: OUTPUT
##D 
##D [1] "please run coding function to see the order in which you"
##D [1] "must supply the first-stage sample sizes or prevalences"
##D [1] " Type ?coding for details!"
##D [1] "For calls requiring n1 or prev as input, use the following order"
##D       ylevel z new.z n2
##D  [1,]      0 1     1 10
##D  [2,]      0 2     2 10
##D  [3,]      0 3     3 10
##D  [4,]      0 4     4 10
##D  [5,]      0 5     5 10
##D  [6,]      0 6     6 10
##D  [7,]      1 1     1  8
##D  [8,]      1 2     2 10
##D  [9,]      1 3     3 10
##D [10,]      1 4     4 10
##D [11,]      1 5     5 10
##D [12,]      1 6     6 10
##D [1] "Check sample sizes/prevalences"
##D $n
##D [1] 9166
##D 
##D $design
##D       ylevel zlevel         prev n2   prop samp.2nd
##D  [1,]      0      1 0.0197823937 10 0.5230       95
##D  [2,]      0      2 0.1339020772 10 0.2841      349
##D  [3,]      0      3 0.6698813056 10 0.0726      446
##D  [4,]      0      4 0.0544015826 10 0.4488      224
##D  [5,]      0      5 0.0503214639 10 0.2480      114
##D  [6,]      0      6 0.0467359050 10 0.4922      211
##D  [7,]      1      1 0.0009891197  8 1.0000        9
##D  [8,]      1      2 0.0040801187 10 1.0000       37
##D  [9,]      1      3 0.0127349159 10 1.0000      117
##D [10,]      1      4 0.0022255193 10 1.0000       20
##D [11,]      1      5 0.0032146390 10 1.0000       29
##D [12,]      1      6 0.0017309594 10 1.0000       16
##D 
##D $se
##D                    [,1]
##D (Intercept) 1.193504705
##D sex         0.217235702
##D weight      0.006718422
##D age         0.014588813
##D angina      0.245831383
##D chf         0.077039239
##D lve         0.010071151
##D surg        0.179887419

## Keywords: 'design'.


