###--- >>> `survdiff' <<<----- Test Survival Curve Differences

	## alias	 help(survdiff)
	## alias	 help(survdiff.fit)

##___ Examples ___:

## Two-sample test
data(ovarian)
survdiff(Surv(futime, fustat) ~ rx,data=ovarian)
rm(ovarian)
## Stratified 7-sample test
data(lung)
survdiff(Surv(time, status) ~ pat.karno + strata(inst), data=lung)
rm(lung)

## need "date" package for this example
if (require("date",quietly=TRUE)){
  data(heart)
  data(ratetables)
  ## Expected survival for heart transplant patients based on
  ## US mortality tables
  expect <- survexp(futime ~ ratetable(age=(accept.dt - birth.dt),
sex=1,year=accept.dt,race="white"), jasa, cohort=F,
ratetable=survexp.usr)
  ## actual survival is much worse (no surprise)
  print(survdiff(Surv(jasa$futime, jasa$fustat) ~ offset(expect)))
  detach("package:date")
  rm(jasa,jasa1,heart,survexp.az,survexp.azr,survexp.fl,survexp.flr,survexp.mn,survexp.mnwhite,survexp.us,survexp.usr,survexp.wnc)
}

## Keywords: 'survival'.


