###--- >>> `sedist' <<<----- Find a Matrix of Distances Between Positions Based on Structural Equivalence

	## alias	 help(sedist)

##___ Examples ___:

#Create a random graph with _some_ edge structure
g.p<-sapply(runif(20,0,1),rep,20)  #Create a matrix of edge 
                                   #probabilities
g<-rgraph(20,tprob=g.p)            #Draw from a Bernoulli graph 
                                   #distribution

#Get SE distances
g.se<-sedist(g)

#Plot a metric MDS of vertex positions in two dimensions
library(mva)
plot(cmdscale(as.dist(g.se)))

## Keywords: 'classif', 'cluster', 'network'.


