###--- >>> `scatterplot3d' <<<----- 3D Scatter Plot

	## alias	 help(scatterplot3d)

##___ Examples ___:

    ## On some devices not all colors can be displayed.
    ## Try the postscript device or use highlight.3d = FALSE.

    ## example 1
    z <- seq(-10, 10, 0.01)
    x <- cos(z)
    y <- sin(z)
    scatterplot3d(x, y, z, highlight.3d=TRUE, col.axis="blue",
        col.grid="lightblue", main="scatterplot3d -- example 1", pch=20)

    ## example 2
    temp <- seq(-pi, 0, length = 50)
    x <- as.vector(rep(1, 50) %*% t(cos(temp)))
    y <- as.vector(cos(temp) %*% t(sin(temp)))
    z <- as.vector(sin(temp) %*% t(sin(temp)))
    scatterplot3d(x, y, z, highlight.3d=TRUE, 
        col.axis="blue", col.grid="lightblue",
        main="scatterplot3d -- example 2", pch=20)

    ## example 3
    temp <- seq(-pi, 0, length = 50)
    x <- as.vector(rep(1, 50) %*% t(cos(temp)))
    y <- as.vector(cos(temp) %*% t(sin(temp)))
    z <- 10 * as.vector(sin(temp) %*% t(sin(temp)))
    color <- rep("green", length(x))
    temp <- seq(-10, 10, 0.01)
    x <- c(x, cos(temp))
    y <- c(y, sin(temp))
    z <- c(z, temp)
    color <- c(color, rep("red", length(temp)))
    scatterplot3d(x, y, z, color, pch=20, zlim=c(-2, 10),
        main="scatterplot3d -- example 3")

    ## example 4
    my.mat <- matrix(runif(25), nrow=5)
    dimnames(my.mat) <- list(LETTERS[1:5], letters[11:15])
    my.mat # the matrix we want to plot ...
    
    s3d.dat <- data.frame(cols=as.vector(col(my.mat)), 
        rows=as.vector(row(my.mat)), 
        value=as.vector(my.mat))
    scatterplot3d(s3d.dat, type="h", lwd=5, pch=" ", 
        x.ticklabs=colnames(my.mat), y.ticklabs=rownames(my.mat), 
        color=grey(25:1/40), main="scatterplot3d -- example 4")

    ## example 5
    data(trees)
    s3d <- scatterplot3d(trees, type="h", highlight.3d=TRUE, 
        pch=16, main="scatterplot3d -- example 5")
    # Now adding some points to the "scatterplot3d"
    s3d$points3d(seq(10,20,2), seq(85,60,-5), seq(60,10,-10), 
        col="blue", type="h", pch=16)        

## Keywords: 'hplot'.


