###--- >>> `nls' <<<----- Nonlinear Least Squares

	## alias	 help(nls)
	## alias	 help(anova.nls)
	## alias	 help(anovalist.nls)
	## alias	 help(coef.nls)
	## alias	 help(deviance.nls)
	## alias	 help(df.residual.nls)
	## alias	 help(fitted.nls)
	## alias	 help(logLik.nls)
	## alias	 help(print.nls)
	## alias	 help(residuals.nls)
	## alias	 help(summary.nls)
	## alias	 help(print.summary.nls)
	## alias	 help(weights.nls)
	## alias	 help(AIC.nls)

##___ Examples ___:

data( DNase )
DNase1 <- DNase[ DNase$Run == 1, ]
## using a selfStart model
fm1DNase1 <- nls( density ~ SSlogis( log(conc), Asym, xmid, scal ), DNase1 )
summary( fm1DNase1 )
## using conditional linearity
fm2DNase1 <- nls( density ~ 1/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1,
                  start = list( xmid = 0, scal = 1 ),
                  alg = "plinear", trace = TRUE )
summary( fm2DNase1 )
## without conditional linearity
fm3DNase1 <- nls( density ~ Asym/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1,
                  start = list( Asym = 3, xmid = 0, scal = 1 ),
                  trace = TRUE )
summary( fm3DNase1 )
## weighted nonlinear regression
data(Puromycin)
Treated <- Puromycin[Puromycin$state == "treated", ]
weighted.MM <- function(resp, conc, Vm, K)
{
    ## Purpose: exactly as white book p.451 -- RHS for nls()
    ##  Weighted version of Michaelis-Menten model
    ## -------------------------------------------------------------------------
    ## Arguments: `y', `x' and the two parameters (see book)
    ## -------------------------------------------------------------------------
    ## Author: Martin Maechler, Date: 23 Mar 2001, 18:48

    pred <- (Vm * conc)/(K + conc)
    (resp - pred) / sqrt(pred)
}

Pur.wt <- nls( ~ weighted.MM(rate, conc, Vm, K), data = Treated,
              start = list(Vm = 200, K = 0.1),
              trace = TRUE)

## Keywords: 'nonlinear', 'regression', 'models'.


