###--- >>> `partition' <<<----- Partitioning by Iterative Optimization

	## alias	 help(partition)

##___ Examples ___:

data(iris3)
iris <- rbind(iris3[,,1], iris3[,,2], iris3[,,3])
pp <- partition(iris,3)
# Plot the results in the plane comprising the first two columns of `a'
x <- iris[,1]       # for convenience
y <- iris[,2]
plot(x, y, type="n")     # set up plot scales, etc.
points(x[pp==1], y[pp==1],pch="*")
points(x[pp==2], y[pp==2],pch="+")
points(x[pp==3], y[pp==3],pch="o")

# Secondly, specifying guesses at cluster centers.
irismean <- t(apply(iris3, c(2, 3), 'mean'))
library(mva)
km <- partition(iris, irismean)
wrong <- km$cluster!=rep(1:3, c(50, 50, 50))
plot(iris[,2], iris[,3], type="n")
text(iris[!wrong, 2], iris[!wrong, 3], km$cluster)
# identify cluster membership that is correct
points(iris[wrong, 2], iris[wrong, 3], pch=15, col=2)
# boxes for points in error
title(main="K-Means Clustering of the Iris Data")

## Keywords: 'cluster', 'multivariate'.


