###--- >>> `clusplot.default' <<<----- Bivariate Cluster Plot (clusplot)

	## alias	 help(clusplot.default)

##___ Examples ___:

## plotting votes.diss(dissimilarity) in a bivariate plot and
## partitioning into 2 clusters
data(votes.repub)
votes.diss <- daisy(votes.repub)
votes.clus <- pam(votes.diss, 2, diss = TRUE)$clustering
clusplot(votes.diss, votes.clus, diss = TRUE, shade = TRUE)

if(interactive()) #  uses identify() *interactively* :
  clusplot(votes.diss, votes.clus, diss = TRUE, shade = TRUE,
           labels = 1)

## plotting iris (dataframe) in a 2-dimensional plot and partitioning
## into 3 clusters.
data(iris)
iris.x <- iris[, 1:4]
clusplot(iris.x, pam(iris.x, 3)$clustering, diss = FALSE,
         plotchar = TRUE, color = TRUE)

## Keywords: 'cluster', 'hplot'.


