###--- >>> `table' <<<----- Cross Tabulation

	## alias	 help(table)
	## alias	 help(summary.table)
	## alias	 help(print.summary.table)
	## alias	 help(as.data.frame.table)
	## alias	 help(as.table)
	## alias	 help(as.table.default)
	## alias	 help(is.table)

##___ Examples ___:

## Simple frequency distribution
table(rpois(100,5))
data(warpbreaks)
attach(warpbreaks)
## Check the design:
table(wool, tension)
data(state)
table(state.division, state.region)

data(airquality)
attach(airquality)
# simple two-way contingency table
table(cut(Temp, quantile(Temp)), Month)

a <- letters[1:3]
table(a, sample(a))                    # dnn is c("a", "")
table(a, sample(a), deparse.level = 0) # dnn is c("", "")
table(a, sample(a), deparse.level = 2) # dnn is c("a", "sample(a)")

## xtabs() <-> as.data.frame.table() :
data(UCBAdmissions) ## already a contingency table
DF <- as.data.frame(UCBAdmissions)
class(tab <- xtabs(Freq ~ ., DF))# xtabs & table
## tab *is* ``the same'' as the original table:
all(tab == UCBAdmissions) 
all.equal(dimnames(tab), dimnames(UCBAdmissions))

## Keywords: 'category'.


