###--- >>> `Oarray' <<<----- Arrays with arbitrary offsets

	## alias	 help(Oarray)
	## alias	 help(as.Oarray)
	## alias	 help(as.array.default)
	## alias	 help(as.array)
	## alias	 help(as.array.Oarray)
	## alias	 help(is.Oarray)
	## alias	 help(.handleTheOffset)
	## alias	 help([.Oarray)
	## alias	 help([<-.Oarray)
	## alias	 help(print.Oarray)

##___ Examples ___:

fred <- Oarray(1:24, 2:4, list(c("sad", "happy"), NULL, NULL),
  offset=rep(7, 3))

tmp <- as.array(fred)
fred1 <- as.Oarray(tmp, offset=rep(7, 3))
stopifnot(is.Oarray(fred1), all.equal(fred, fred1))

print.default(fred)  # print method provides numbers for
fred                 # non-named extents

# examples of extraction

fred[] # unclasses fred
fred["sad", 7, -9]
fred["sad", 7, -9, drop=FALSE]
fred[-8, , 7:8]

i <- 8:9; fred[, , i+1]
how.I.feel <- "happy"; fred[how.I.feel, , -(7:8)]

# examples of assignment

fred["sad", 7, -9] <- NA
fred[, , i] <- 100
fred[how.I.feel, , -(7:8)] <- Inf

# now use negative offsets and suppress usual behaviour

fred <- Oarray(24:1, 2:4, offset=c(-1, -2, 7), drop.negative=FALSE)
fred[] <- 1:24
fred[-(1:0), , 7:8]
fred[-(1:0), , 7:8] <- 100
dimnames(fred) <- list(c("sad", "happy"), NULL, NULL)
fred["sad", -2, 10] <- NA

## Keywords: 'array'.


