###--- >>> `xmp06.12' <<<----- data from Example 6.12

	## alias	 help(xmp06.12)

##___ Examples ___:

data(xmp06.12)
attach(xmp06.12)
gamma.MoM <- function(x) {
   ## calculate method of moments estimates for gamma distribution
   xbar <- mean(x)
   mnSqDev <- mean((x - xbar)^2)
   c(alpha = xbar^2/mnSqDev, beta = mnSqDev/xbar)
}
## method of moments estimates
print(surv.MoM <- gamma.MoM(Survival))
## evaluating the negative log-likelihood
gammaLlik <- function(x) {
   ## argument x is a vector of shape (alpha) and scale (beta)
   -sum(dgamma(Survival, shape = x[1], scale = x[2], log = TRUE))
}
## maximum likelihood estimates - use MoM estimates as starting value
MLE <- optim(par = surv.MoM, gammaLlik)
print(MLE)
detach()

## Keywords: 'datasets'.


