###--- >>> `nls' <<<----- Nonlinear Least Squares

	## alias	 help(nls)
	## alias	 help(anova.nls)
	## alias	 help(anovalist.nls)
	## alias	 help(coef.nls)
	## alias	 help(deviance.nls)
	## alias	 help(df.residual.nls)
	## alias	 help(fitted.nls)
	## alias	 help(logLik.nls)
	## alias	 help(print.nls)
	## alias	 help(residuals.nls)
	## alias	 help(summary.nls)
	## alias	 help(print.summary.nls)
	## alias	 help(weights.nls)

##___ Examples ___:

library( nls )
data( DNase )
DNase1 <- DNase[ DNase$Run == 1, ]
## using a selfStart model
fm1DNase1 <- nls( density ~ SSlogis( log(conc), Asym, xmid, scal ), DNase1 )
summary( fm1DNase1 )
## using conditional linearity
fm2DNase1 <- nls( density ~ 1/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1,
                  start = list( xmid = 0, scal = 1 ),
                  alg = "plinear", trace = TRUE )
summary( fm2DNase1 )
## without conditional linearity
fm3DNase1 <- nls( density ~ Asym/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1,
                  start = list( Asym = 3, xmid = 0, scal = 1 ),
                  trace = TRUE )
summary( fm3DNase1 )

## Keywords: 'nonlinear', 'regression', 'models'.


