

read.ts(tseries)                             R Documentation

_R_e_a_d _T_i_m_e _S_e_r_i_e_s _D_a_t_a

_D_e_s_c_r_i_p_t_i_o_n_:

     Reads a time series file. Each row of the file repre-
     sents an observation and each column contains a vari-
     able. The first row possibly contains the names of the
     variables.

_U_s_a_g_e_:

     read.ts (file, header = FALSE, sep = "", skip = 0, ...)

_A_r_g_u_m_e_n_t_s_:

    file: the name of the file which the data are to be read
          from. Each line of the file contains one observa-
          tion of the variables.

  header: a logical value indicating whether the file con-
          tains the names of the variables as its first
          line.

     sep: the field separator character. Values on each line
          of the file are separated by this character.

    skip: the number of lines of the data file to skip
          before beginning to read data.

     ...: Additional arguments for `ts' such as, e.g.,
          `start'.

_A_u_t_h_o_r_(_s_)_:

     A. Trapletti

_S_e_e _A_l_s_o_:

     `ts'.

_E_x_a_m_p_l_e_s_:

     data (sunspots)
     st <- start(sunspots)
     fr <- frequency(sunspots)
     write (sunspots, "sunspots", ncolumns=1)
     x <- read.ts ("sunspots", start=st, frequency=fr)
     plot (x)
     system ("rm -f sunspots")

