###--- >>> `frailty' <<<----- (Approximate) Frailty models

	## alias	 help(frailty)
	## alias	 help(frailty.gamma)
	## alias	 help(frailty.gaussian)
	## alias	 help(frailty.t)

##___ Examples ___:

data(kidney)
kfit <- coxph(Surv(time, status)~ age + sex + disease + frailty(id), kidney)
kfit0 <- coxph(Surv(time, status)~ age + sex + disease, kidney)
kfitm1 <- coxph(Surv(time,status) ~ age + sex + disease + 
		frailty(id, dist='gauss'), kidney)
coxph(Surv(time, status) ~ age + sex + frailty(id, dist='gauss', method='aic',caic=T), kidney)
# uncorrected aic
coxph(Surv(time, status) ~ age + sex + frailty(id, method='aic', caic=F), kidney)

data(rats)
rfit2a <- survreg(Surv(time, status) ~ rx +
		  frailty.gaussian(litter, df=13, sparse=F), rats )
rfit2b <- survreg(Surv(time, status) ~ rx +
		  frailty.gaussian(litter, df=13, sparse=T), rats )
rfit2a
rfit2b

## Keywords: 'survival'.


