###--- >>> `nlme' <<<----- Nonlinear Mixed-Effects Models

	## alias	 help(nlme)
	## alias	 help(nlme.formula)

##___ Examples ___:

library(nlme)
data(Soybean)
## all parameters as fixed and random effects
fm1 <- nlme(weight ~ SSlogis(Time, Asym, xmid, scal), data = Soybean,
            fixed = Asym + xmid + scal ~ 1, start = c(18, 52, 7.5),
            control = list(nlmStepMax = 1.0))
## only Asym and xmid as random, with a diagonal covariance 
fm2 <- nlme(weight ~ SSlogis(Time, Asym, xmid, scal), data = Soybean,
            fixed = Asym + xmid + scal ~ 1, random = pdDiag(Asym + xmid ~ 1),
            start = c(18, 52, 7.5))

## Keywords: 'models'.


