###--- >>> `gnlr3' <<<----- Fit a Generalized Nonlinear Regression Model for Three Parameter Distributions

	## alias	 help(gnlr3)
	## alias	 help(coefficients.gnlr3)
	## alias	 help(deviance.gnlr3)
	## alias	 help(df.residual.gnlr3)
	## alias	 help(fitted.values.gnlr3)
	## alias	 help(residuals.gnlr3)
	## alias	 help(weights.gnlr3)

##___ Examples ___:

y <- rgamma(20,2,1)
sex <- c(rep(0,10),rep(1,10))
sexf <- gl(2,10)
age <- rpois(20,10)
# linear regression with the generalized gamma distribution
mu <- function(p) p[1]+p[2]*sex+p[3]*age
gnlr3(y, dist="gamma", mu=mu, pmu=rep(1,3), pshape=0, pfamily=0)
# or equivalently
gnlr3(y, dist="gamma", mu=~sexf+age, pmu=rep(1,3),
	pshape=0, pfamily=0)
# or
gnlr3(y, dist="gamma", linear=~sex+age, pmu=rep(1,3),
	pshape=0, pfamily=0)
# or
gnlr3(y, dist="gamma", mu=~b0+b1*sex+b2*age,
	pmu=list(b0=1,b1=1,b2=1), pshape=0, pfamily=0)
#
# nonlinear regression with generalized gamma distribution
mu <- function(p, linear) p[1]+exp(linear)
gnlr3(y, dist="gamma", mu=mu, linear=~sex+age, pmu=rep(1,4),
	pshape=0, pfamily=0)
# or equivalently
gnlr3(y, dist="gamma", mu=~b4+exp(b0+b1*sex+b2*age),
	pmu=list(b0=1,b1=1,b2=1,b4=1), pshape=0, pfamily=0)
#
# include regression for the shape parameter with same mu function
shape <- function(p) p[1]+p[2]*sex+p[3]*age
gnlr3(y, dist="gamma", mu=mu, linear=~sexf+age, shape=shape,
	pmu=rep(1,4), pshape=rep(0,3), pfamily=0)
# or equivalently
gnlr3(y, dist="gamma", mu=mu, linear=list(~sexf+age,~sex+age,NULL),
	pmu=rep(1,4), pshape=rep(0,3), pfamily=0)
# or
gnlr3(y, dist="gamma", mu=mu, linear=~sexf+age,
	shape=~c0+c1*sex+c2*age, pmu=rep(1,4),
	pshape=list(c0=0,c1=0,c2=0), pfamily=0)
# include regression for the family parameter with same mu
# and shape functions
family <- function(p) p[1]+p[2]*sex+p[3]*age
gnlr3(y, dist="gamma", mu=mu, linear=~sexf+age, shape=shape,
	family=shape, pmu=rep(1,4), pshape=rep(0,3), pfamily=rep(0,3))
# or equivalently
gnlr3(y, dist="gamma", mu=mu,
	linear=list(~sex+age,~sex+age,~sex+age), pmu=rep(1,4),
	pshape=rep(0,3), pfamily=rep(0,3))
# or
gnlr3(y, dist="gamma", mu=~b4+exp(b0+b1*sex+b2*age),
	shape=~c0+c1*sex+c2*age, family=~d0+d1*sex+d2*age,
	pmu=list(b0=1,b1=1,b2=1,b4=1), pshape=list(c0=0,c1=0,c2=0),
	pfamily=list(d0=0,d1=0,d2=0))



