###--- >>> `survkit' <<<----- Weibull and Cox Models with Random Effects

	## alias	 help(survkit)

##___ Examples ___:

y <- trunc(rweibull(20,2,20))
cens <- rbinom(20,1,0.9)
id <- gl(2,10)
x <- rnorm(20)
# Kaplan-Meier estimates
survkit(y, censor=cens, model="Kaplan")
# null Weibull model
survkit(y, censor=cens)
# one time-constant covariate
survkit(y, censor=cens, ccov=~x)
# stratify
survkit(y, censor=cens, ccov=~x, strata=id)
# estimate a normal random effect
survkit(y, censor=cens, ccov=~x, random=id, dist="normal",
	estimate=c(0.1,10,0.01), moments=T)
# try a fixed value for the normal random effect
survkit(y, censor=cens, ccov=~x, random=id, dist="normal",
	estimate=1.3)
# estimate a log-gamma random effect
survkit(y, censor=cens, ccov=~x, random=id, dist="loggamma",
	estimate=c(0.1,10,0.01))
# estimate a log-gamma random effect by integrating it out
survkit(y, censor=cens, ccov=~x, dist="loggamma", estimate=1.4,
	integ=id, jointmode=T)
# try a fixed value of the log-gamma random effect, integrating it out
survkit(y, censor=cens, ccov=~x, dist="loggamma", estimate=1,
	integ=id)
#
# Cox model with one time-constant covariate
print(z <- survkit(y, censor=cens, ccov=~x, model="Cox", residuals=T,
	baseline=T))
residuals(z)
baseline(z)
# obtain the quantiles
print(z <- survkit(y, censor=cens, ccov=~x, model="Cox",
	survival="quantiles", svalues=seq(10,90,by=10)))
survival(z)
# estimate a log-gamma random effect
survkit(y, censor=cens, ccov=~x, model="Cox", random=id,
	dist="loggamma", estimate=c(0.1,10,0.01))



