###--- >>> `control' <<<----- Control Variate Calculations

	## alias	 help(control)

##___ Examples ___:

# Use of control variates for the variance of the air-conditioning data
mean.fun <- function(d, i)
{    m <- mean(d$hours[i])
     n <- nrow(d)
     v <- (n-1)*var(d$hours[i])/n^2
     c(m, v)
}
data(aircondit)
air.boot <- boot(aircondit, mean.fun, R=999)
control(air.boot,index=2,bias.adj=T)
air.cont <- control(air.boot, index=2)
# Now let us try the variance on the log scale.
air.cont1 <- control(air.boot, t0=log(air.boot$t0[2]), t=log(air.boot$t[,2]))

## Keywords: 'nonparametric'.


