###--- >>> `qr' <<<----- The QR Decomposition of a Matrix

	## alias	 help(qr)
	## alias	 help(qr.coef)
	## alias	 help(qr.qy)
	## alias	 help(qr.qty)
	## alias	 help(qr.resid)
	## alias	 help(qr.fitted)
	## alias	 help(qr.solve)
	## alias	 help(is.qr)
	## alias	 help(as.qr)

##___ Examples ___:

## The determinant of a matrix  -- if you really must have it
det2 <- function(x) prod(diag(qr(x)$qr))*(-1)^(ncol(x)-1)
det2(print(cbind(1,1:3,c(2,0,1))))

hilbert <- function(n) { i <- 1:n; 1 / outer(i - 1, i, "+") }
h9 <- hilbert(9); h9
qr(h9)$rank           #--> only 7
qrh9 <- qr(h9, tol = 1e-10)
qrh9$rank             #--> 9
##-- Solve linear equation system  H %*% x = y :
y <- 1:9/10
x <- qr.solve(h9, y, tol = 1e-10) # or equivalently :
x <- qr.coef(qrh9, y) #-- is == but much better than
                      #-- solve(h9) %*% y
h9 %*% x              # = y

## Keywords: 'algebra', 'array', 'regression'.


