###--- >>> `kde2d' <<<----- Two-Dimensional Kernel Density Estimation

	## alias	 help(kde2d)

##___ Examples ___:

data(geyser)
attach(geyser)
plot(duration, waiting, xlim=c(0.5,6), ylim=c(40,100))
f1 <- kde2d(duration, waiting, n=50, lims=c(0.5,6,40,100))
image(f1, zlim = c(0, 0.05))
f2 <- kde2d(duration, waiting, n=50, lims=c(0.5,6,40,100),
   h = c(width.SJ(duration), width.SJ(waiting)) )
image(f2, zlim = c(0, 0.05))
persp(f2, phi=30, theta=20, d=5)

plot(duration[-272], duration[-1], xlim=c(0.5, 6), 
    ylim=c(1, 6),xlab="previous duration", ylab="duration")
f1 <- kde2d(duration[-272], duration[-1], 
   h=rep(1.5, 2), n=50, lims=c(0.5,6,0.5,6))
contour(f1 ,xlab="previous duration",
    ylab="duration", levels = c(0.05, 0.1, 0.2, 0.4) )
f1 <- kde2d(duration[-272], duration[-1], 
   h=rep(0.6, 2), n=50, lims=c(0.5,6,0.5,6))
contour(f1 ,xlab="previous duration",
    ylab="duration", levels = c(0.05, 0.1, 0.2, 0.4) )
f1 <- kde2d(duration[-272], duration[-1], 
   h=rep(0.4, 2), n=50, lims=c(0.5,6,0.5,6))
contour(f1 ,xlab="previous duration",
    ylab="duration", levels = c(0.05, 0.1, 0.2, 0.4) )
detach("geyser")

## Keywords: 'dplot'.


