<?php
function adminer_object() {
	include_once "./plugins/plugin.php";
	include_once "./plugins/login-password-less.php";
	return new AdminerPlugin(array(
		// TODO: inline the result of password_hash() so that the password is not visible in source codes
		new AdminerLoginPasswordLess(password_hash("abc123", PASSWORD_DEFAULT)),
	));
}

require __DIR__ . '/vendor/autoload.php';
// PHP console stuff:
$PCconnector = \PhpConsole\Connector::getInstance();
$PCconnector->setPassword("Geheim123");
$PCevalProvider = $PCconnector->getEvalDispatcher()->getEvalProvider();
$PCevalProvider->addSharedVar('post', $_POST); // so "return $post" code will return $_POST
$PCevalProvider->setOpenBaseDirs(array(__DIR__)); // see http://php.net/open-basedir
$PCconnector->startEvalRequestsListener(); // must be called in the end of all configurations
$PCconnector->getDebugDispatcher()->setDumper(
    new \PhpConsole\Dumper(6, 20, 60) // set new dumper with levelLimit=2, itemsCountLimit=10, itemSizeLimit=10
);

// Call debug from global PC class-helper (most short & easy way)
\PhpConsole\Helper::register(); // required to register PC class in global namespace, must be called only once
\PC::db('PhpConsole initialized!)'); // means "db" will be handled as debug tag

include "./adminer.php";
